/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KDARDECLARATIONS_H_
#define _KDARDECLARATIONS_H_

#include <qstring.h>

/**
 * Extension for archive slices.
 */
const char* const EXTENSION = "dar";
/**
 * Extension for kdar profiles.
 */
const char* const KDAREXTENSION = ".kdar";
/**
 * Keyword for KFileDialogs to remember most recently opened directory
 */
const QString KDARDIRKEY( ":kdardirkey" );
/**
 * Name of KDar's KWallet password folder
 */
const QString KDARKWALLETFOLDER( "KDar Encryption" );
/**
 * milliseconds for messages in statusbar
 */
const int DURATION( 5000 );
/**
 * pass this as a duration to make statusbar messages stay indefinitely.
 */
const int FOREVER( 0 );
/**
 * Slice-size-checking interval, in milliseconds.
 */
const int CHECKINTERVAL( 1000 );
/**
 * Progressbar-update interval, in milliseconds
 */
const int PROGRESSINTERVAL( 1000 );
/**
 * Time-elapsed interval, in milliseconds.
 */
const int TIMEELAPSEDINTERVAL( 1000 );

#endif // _KDARDECLARATIONS_H_
