/***************************************************************************
 *   Copyright (C) 2003,2004 by Johnathan Burchill                         *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/


#include "kdarcreatedialog.h"
#include "kdarConfig.h"

#include <kdebug.h>
#include <kfiledialog.h>
#include <klineedit.h>
#include <kurl.h>
#include <kurlrequester.h>

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qstring.h>
#include <qtabwidget.h>
#include <qvbox.h>
#include <qlayout.h>

#include <iostream>

kdarCreateDialog::kdarCreateDialog( QWidget* parent, const char* name, bool modal, WFlags fl)
: archiveCreateDlg( parent, name, modal, fl )
{
        rootDirectoryKURLRequester->setMode(26); //existing local directory
        rootDirectoryKURLRequester->setCaption("Select the directory you want to backup:");
        archiveNameKURLRequester->setMode(17); //local file
        archiveNameKURLRequester->setCaption("Select a name for this archive:");
        referenceArchiveKURLRequester->setMode(25); //existing local file
        referenceArchiveKURLRequester->setFilter("*.dar"); //dar archives
        referenceArchiveKURLRequester->setCaption("Select an archive to use as a reference for this backup:");
}

kdarCreateDialog::~kdarCreateDialog()
{
}

/*$SPECIALIZATION$*/
void kdarCreateDialog::setKDarConfig( KDarConfig* createConfig )
{
        m_createConfig = createConfig;
}

void kdarCreateDialog::slotChooseRootDirectory(const QString & theSelection)
{
        if (theSelection != NULL)
        {
                archiveNameLabel->setEnabled(true);
                archiveNameKURLRequester->setEnabled(true);
                slotChooseArchiveName( archiveNameKURLRequester->lineEdit()->text() );
        }
}

void kdarCreateDialog::slotChooseArchiveName( const QString & theSelection )
{
        if ( !theSelection.isEmpty() )
        {
                diffBackupCheckBox->setEnabled( true );
        }
        else
        {
                diffBackupCheckBox->setEnabled( false );
        }
        //automatically exclude the storage directory from the backup if the
        //directory is a child of the directory to back up.

        //The directory mask type "auto" will be used to signify that this mask
        //is automatically generated, and the user cannot edit or remove it.

        //First, if theSelection is empty, we have no archivename yet, so
        //the auto filter should not be in the list of directory filters.
        //If theSelection is not empty, we need to replace the current Auto filter.
        //In either case, remove the auto filter if it exists by traversing the list.
        QListViewItem * currentItem = m_createConfig->directoryFiltersListView->firstChild();
        while( currentItem )
        {
                if ( currentItem->text( 0 ) == "Auto" )
                {
                        kdDebug() << "kdarCreateDialog::slotChooseArchiveName() : deleting old auto filter." << endl;
                        delete currentItem;
                        currentItem = 0;
                }
                if ( currentItem )
                {
                        currentItem = currentItem->nextSibling();
        }
        }

        if ( !currentItem )
        {
                //We deleted the "Auto" filter, so update the lists
                m_createConfig->slotUpdateDirectoryMaskList();
        }

        if ( !theSelection.isEmpty() )
        {
                QString rootDirectory = rootDirectoryKURLRequester->lineEdit()->text();
                QString newArchiveName( theSelection );
                //If theSelection doesn't start with '/', the user wants to override
                //the default storage directory.
                if ( theSelection[0] != '/' )
                {
                        KURL archiveStorageDirKURL( m_createConfig->archiveStorageDirectory() );
                        newArchiveName = archiveStorageDirKURL.path( 1 ) + theSelection;
                }
                //We only add the storage directory to filter list if it is a child of rootDirectory
                if ( newArchiveName.left( rootDirectory.length() ) == rootDirectory )
                {
                        //the new archive name is in a subdirectory of
                        //the root directory, so put the new archive directory
                        //in the list of excluded paths
                        KURL newArchiveKURL = newArchiveName;
                        QString newArchiveDirectory = newArchiveKURL.directory(true, false);

                        if ( !newArchiveDirectory.isEmpty() )
                        {
                                //Add the filter
                                QString type( "Auto" );
                                kdDebug() << "kdarCreateDialog::slotChooseArchiveName() 12: adding new Auto directory filter: " << newArchiveDirectory << endl;
                                QListViewItem* item = new QListViewItem( m_createConfig->directoryFiltersListView, type, newArchiveDirectory );
                                //Disable this item. It is automatically added/removed based
                                //on root directory and newArchiveName, so don't let the user
                                //change it.
                                item->setEnabled( false );
                                m_createConfig->slotUpdateDirectoryMaskList();
                        }
                }
        }
}

#include "kdarcreatedialog.moc"

