/***************************************************************************
 *   Copyright (C) 2003,2004 by Johnathan Burchill                         *
 *   jkerrb@users.sourceforge.net                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef _KDARTARLISTINGEVENT_H_
#define _KDARTARLISTINGEVENT_H_

#include "kdarEnums.h"
#include <qevent.h>
#include <qstring.h>

class kdarListViewItem;

class kdarTarListingEvent : public QCustomEvent
{
public:
    kdarTarListingEvent( kdarListViewItem *qdirectory,
                         const QString &qflag,
                         const QString &qperm,
                         const QString &quid,
                         const QString &qgid,
                         const QString &qsize,
                         const QString &qdate,
                         const QString &qfilename,
                         const bool qisdir,
                         const bool qhaschildren )
    : QCustomEvent( KDar::TARLISTING ),
                  m_directory( qdirectory ),
                  m_flag( qflag ),
                  m_perm( qperm ),
                  m_uid( quid ),
                  m_gid( qgid ),
                  m_size( qsize ),
                  m_date( qdate ),
                  m_filename( qfilename ),
                  m_isDir( qisdir ),
                  m_hasChildren( qhaschildren )
    {}

    kdarListViewItem * directory() const { return m_directory; }
    QString flag() const { return m_flag; }
    QString perm() const { return m_perm; }
    QString uid() const { return m_uid; }
    QString gid() const { return m_gid; }
    QString size() const { return m_size; }
    QString date() const { return m_date; }
    QString filename() const { return m_filename; }
    bool isDir() const { return m_isDir; }
    bool hasChildren() const { return m_hasChildren; }

private:
    kdarListViewItem * m_directory;
    QString m_flag;
    QString m_perm;
    QString m_uid;
    QString m_gid;
    QString m_size;
    QString m_date;
    QString m_filename;
    bool m_isDir;
    bool m_hasChildren;
};

#endif // _KDARTARLISTINGEVENT_H_
