/***************************************************************************
 *   Copyright (C) 2003 by Johnathan Burchill,,,                           *
 *   jkerrb@users.sourceforge.net                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef _KDARSTATUSBAREVENT_H_
#define _KDARSTATUSBAREVENT_H_

#include "kdardeclarations.h"
#include "kdarEnums.h"

#include <qevent.h>
#include <qstring.h>

class kdarStatusBarEvent : public QCustomEvent
{
public:
    kdarStatusBarEvent( const QString message, const int duration = DURATION )
        : QCustomEvent( KDar::STATUSBAR ),
          m_message( message ),
          m_duration( duration )
    {}

    QString message() const { return m_message; }
    int duration() const { return m_duration; }

private:
    const QString m_message;
    const int m_duration;

};


 #endif // _KDARSTATUSBAREVENT_H_
