/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KDARPROGRESSEVENT_H_
#define _KDARPROGRESSEVENT_H_

#include "kdarEnums.h"

#include <qevent.h>
#include <qstring.h>

class kdarProgressEvent : public QCustomEvent
{
public:

        enum progressCommand
        {
                PROGRESS_START,
                PROGRESS_STOP,
                PROGRESS_INCREASE_ADDED,
                PROGRESS_INCREASE_SKIPPED,
                PROGRESS_INCREASE_TOTAL,
                PROGRESS_SET_TOTAL
        };

        kdarProgressEvent( progressCommand command, long total = 0 )
                : QCustomEvent( KDar::PROGRESS ),
                m_command( command ),
                m_total( total )
{
}

        progressCommand command() const { return m_command; }
        long total() const { return m_total; }

private:

        progressCommand m_command;
        long m_total;
};


 #endif // _KDARPROGRESSEVENT_H_
