/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KDARPOSTLISTVIEWITEMEVENT_H_
#define _KDARPOSTLISTVIEWITEMEVENT_H_

#include <qevent.h>
#include <qstring.h>

/**
 * This class is used for posting a new top-level item to the archive browser.
 * The archive browser can optionally be cleared of its current items.
 *
 * @short Event for posting new top-level items.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class kdarPostListViewItemEvent : public QCustomEvent
{
public:

    /**
     * Constructor
     */
    kdarPostListViewItemEvent( QString text, bool clearView )
        : QCustomEvent( 1006 ),
          m_text( text ),
          m_clearView( clearView ){}

    /**
     * Returns the text to post as the new top-level item in the archive
     * browser.
     */
    QString text() const { return m_text; }
    /**
     * Returns whether to clear the archive browser before adding the new item.
     */
    bool clearView() const { return m_clearView; }

private:

    /**
     * The text to post as the top-level item. This should be the name of the
     * archive.
     */
    QString m_text;
    /**
     * Wether to clear the archive browser before adding the new top-level item.
     */
    bool m_clearView;

};


 #endif // _KDARPOSTLISTVIEWITEMEVENT_H_
