/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KDAREVENTHANDLER_H_
#define _KDAREVENTHANDLER_H_

#include <qobject.h>

class kdarView;
class controller;
class KDarConfig;

class QCustomEvent;

/**
 * Handles all of KDar's custom events. Uses methods from @ref kdarView
 * and @ref controller as necessary to act on those events.
 */
class kdarEventHandler : public QObject
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    kdarEventHandler( QObject *parent, controller *, KDarConfig * );
    /**
     * Destructor
     */
    virtual ~kdarEventHandler();

    virtual void handleEvent( QCustomEvent * );

private:
    /**
     * Write a message to the KDar log file.
     */
    void writeLogMessage( QString & );

    controller *m_controller;
    KDarConfig *m_kdarconfig;
    kdarView *m_view;
};
#endif // _KDAREVENTHANDLER_H_
