/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef _KDARCHECKFILESIZEEVENT_H_
#define _KDARCHECKFILESIZEEVENT_H_

#include "kdarEnums.h"

#include <qevent.h>
#include <qstring.h>

/**
 * This class conveys whether KDar should check the size of the latest-written
 * archive slice. You can start and stop the appropriate QTimer with this event.
 *
 * @short Event for checking the slice size on disk.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */

class kdarCheckFileSizeEvent : public QCustomEvent
{
public:
    enum action
    {
        STARTTIMER,
        STOPTIMER
    };

    /**
     * Constructor
     */
    kdarCheckFileSizeEvent( action checkFileSizeAction )
        : QCustomEvent( KDar::CHECKFILESIZE ),
          m_checkFileSizeAction( checkFileSizeAction ){}

    /**
     * Returns whether to start or stop the filesize checking QTimer.
     */
    action checkFileSizeAction() const { return m_checkFileSizeAction; }
private:

    /**
     * Stores the filesize checking action to perform, i.e. START or STOP
     * the QTimer.
     */
    action m_checkFileSizeAction;

};

#endif // _KDARCHECKFILESIZEEVENT_H_
