/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef _KDARARCHIVEBROWSERUPDATESEVENT_H_
#define _KDARARCHIVEBROWSERUPDATESEVENT_H_

#include "kdarEnums.h"

#include <qevent.h>

/**
 * This class conveys whether the archive browser is allowed to update its
 * contents.
 *
 * @short Archive browser updates event.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class kdarArchiveBrowserUpdatesEvent: public QCustomEvent
{
public:

    /**
     * Data type for the update command.
     */
    enum updateCommand
    {
        ENABLE,
        DISABLE
    };

    /**
     * A QCustomEvent for enabling or disabling archive browser updates.
     * This event is sent to the KDar main event loop while the
     * populateTreeArchiveThread fills a tree item with its children.
     * If we did not disable archive updates during the populate process,
     * the browser would try to sort the item's children each time a new
     * child was added. This gets really slow for directory items that
     * contain many files and subdirectories.
     */
    kdarArchiveBrowserUpdatesEvent( updateCommand command )
        : QCustomEvent( KDar::ARCHIVEBROWSERUPDATES ),
          m_command( command ){}

    /**
     * Returns whether to Enable or Disable archive browser updates.
     */
    updateCommand command() const { return m_command; }

private:

    /**
     * Stores the type of command this event is conveying.
     */
    updateCommand m_command;
};

#endif // _KDARARCHIVEBROWSERUPDATESEVENT_H_
