/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _CREATEARCHIVETHREAD_H_
#define _CREATEARCHIVETHREAD_H_

#include "kdarthread.h"

#include <qmutex.h>
#include <qstring.h>

class KDarConfig;
/**
 * This is the createArchiveThread class. It runs the
 * libdar:op_create creation function, which creates an archive from
 * a filesystem.
 *
 * @short Archive creation thread.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class createArchiveThread : public KDarThread
{
public:
    /**
     * Constructor
     * @param aController the controller responsible for deleting the thread.
     * @param kdarconfig the configuration object (main, create or restore) for this
     * thread.
     */
    createArchiveThread( controller * aController, KDarConfig * kdarconfig );
    ~createArchiveThread();

    void run();

protected:

    QString slicesWritten();

};


#endif // _CREATEARCHIVETHREAD_H_
