/***************************************************************************
 *   Copyright (C) 2006 by Stephen Leaf                                    *
 *   smileaf@smileaf.org                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _AUTOSTART_H_
#define _AUTOSTART_H_

#include <kcmodule.h>
#include <kaboutdata.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <kfileitem.h>
#include <kglobalsettings.h>
#include <qpushbutton.h>
#include <qcombobox.h>

class autostart: public KCModule
{
    Q_OBJECT

public:
    autostart( QWidget *parent=0, const char *name=0, const QStringList& = QStringList() );
    ~autostart();

    virtual void load();
    virtual void save();
    virtual void defaults();
    virtual int buttons();
    virtual QString quickHelp() const;
    virtual const KAboutData *aboutData() const
    { return myAboutData; };

public slots:
	void addCMD();
	void removeCMD();
	void editCMD(QListViewItem*);
	bool editCMD(KFileItem);
	void editCMD();
	void setStartOn(int);
	void selectionChanged(QListViewItem*);

private:
	KAboutData *myAboutData;
	KGlobalSettings *kgs;
    KPushButton* btnAdd;
    KListView* listCMD;
    KPushButton* btnRemove;
    QPushButton* btnProperties;
	QComboBox* cmbStartOn;
};

#endif
