#!/usr/bin/perl

############################################################################
#              xml2pot.pl - extract translatable messages from XML files
#                            -------------------
#   begin                : Thu Jul 19 2001
#   copyright            : (C) 2001-2003 by Claudiu Costin
#   email                : claudiuc@kde.org
############################################################################


###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

use File::Basename;

$dir   = shift @ARGV;
$prog=basename($0);
$version="0.1";

@tags = ("title","description");

&version if ($dir eq "-v" || $dir eq "-V" || $dir eq "--version");
&usage   if ($dir eq "" || $dir eq "-h" || $dir eq "--help");

if (!opendir(DH,$dir)) {
	print "$prog: cannot open $dir!\n" if ($debug=1);
	exit(1);
}

while ($item = readdir(DH)) {
  $filename = "$dir/$item";
	next if (!-f $filename || $filename !~ /\.(puretpl|purescr)$/);
  &extract_msg($filename);
}

closedir(DH);

################ FUNCTIONS ########################3

sub extract_msg($filename) {
  # reseting flags
  foreach $tag (@tags) {
    $seen{$tag} = 0;
    $str{$tag}  = "";
  }
  
  my $title_seen;
  my $description_seen;
  
  return if (!open(F,$filename));
  while ($line=<F>) {
    chop($line);
    reset(%tag_array);
    foreach $tag (@tags) {
      if ($seen{$tag}==0) {
        if ($line =~ /<$tag>(.*)/) {
          if ($line =~ /(.*)<\/$tag>/) {
            $str{$tag} = $line;
            $str{$tag} =~ /(<$tag>.*<\/$tag>)/;
            $str{$tag} = $1;
            $str{$tag} =~ /<$tag>(.*)<\/$tag>/;
            $str{$tag} = $1;
            $seen{$tag}=2;        
          } else {
            $str{$tag}= $line;
            $str{$tag} =~ /<$tag>(.*)/;
            $str{$tag} = $1;
            $seen{$tag}=1;
          }
        }
      }
      if ($seen{$tag}==1) {
        if ( $line =~ /(.*)<\/$tag>/) {
          $match   = $1;
          $match   =~ s/<$tag>//;
          $str{$tag} .= $match;
          $seen{$tag}=2;
        } else {
          $str{$tag} .= $line;
        }      
      }
      
    }
#   print "**" . $line . "\n";
  }
  close(F);
  
  foreach $tag (@tags) {
    ($name,$base,$suffix) = fileparse($filename,".purecfg");
    print <<"EOF";
i18n("$str{$tag}")
EOF
  }
}

sub usage() {
  print <<"EOF";
Usage: $prog [OPTION] <directory>
Extract translatable messages from KcmPureFTPd script XML files

      --help     display this help and exit
      --version  output version information and exit

Report bugs to <claudiuc\@kde.org>.
EOF
  exit(0);
}

sub version() {
  print <<"EOF";
$prog $version
Written by Claudiu Costin <claudiuc\@kde.org>.

This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE
EOF
  exit(0);
}
