/*
 * nvviewwidget.cpp
 *
 *  Copyright (C) 2007 Jürgen Heinemann <undefined(AT)users(DOT)berlios(dot)de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "nvviewwidget.h"
#include "nvviewlistitem.h"

// #include <linux/proc_fs.h>

#include <qvariant.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qdir.h>
#include <qfileinfo.h>

#include <ktabwidget.h>
#include <kdialog.h>
#include <klocale.h>

nvviewwidget::nvviewwidget( QWidget* parent, const char* name, WFlags fl )
                : QWidget( parent, name, fl )
{
        if ( !name )
                setName( "nvviewwidget" );

        nvviewwidgetLayout = new QGridLayout( this, 1, 1, 1, 1, "nvviewwidgetLayout");

        tabWidget = new KTabWidget( this, "tabWidget" );

        nvviewlistitem* m_status = new nvviewlistitem( tabWidget, "agpbridge", "agp/status" );
        tabWidget->insertTab( m_status, trUtf8( "agp status" ) );

        nvviewlistitem* m_registry = new nvviewlistitem( tabWidget, "viewagp", "registry" );
        tabWidget->insertTab( m_registry, trUtf8( "kernel modul" ) );

        nvviewlistitem* m_viewagp = new nvviewlistitem( tabWidget, "viewagp", "agp/card" );
        tabWidget->insertTab( m_viewagp, trUtf8( "agp card" ) );

        nvviewlistitem* m_agpbridge = new nvviewlistitem( tabWidget, "agpbridge", "agp/host-bridge" );
        tabWidget->insertTab( m_agpbridge, trUtf8( "agp host bridge" ) );

        // Alle Karten Anzeigen!
        QDir ppd( "/proc/driver/nvidia/cards/" );
        if ( ppd.exists() ) {
            ppd.setFilter( QDir::Files | QDir::NoSymLinks );
            const QFileInfoList *list = ppd.entryInfoList();
            QFileInfoListIterator it( *list );
            QFileInfo *fi;
            while ( ( fi = it.current() ) != 0 ) {
              QString get( "cards/" );
              get.append( fi->fileName().latin1() );
              tabWidget->insertTab(
                  new nvviewlistitem( tabWidget, "cards_tab", get )
                  , trUtf8( "%1" ).arg( get ).replace( "s/", "" )
              );
              ++it;
            }
        }

        nvviewwidgetLayout->addWidget( tabWidget, 0, 0 );

        resize( QSize(387, 296).expandedTo(minimumSizeHint()) );
        clearWState( WState_Polished );
}

nvviewwidget::~nvviewwidget()
{}

#include "nvviewwidget.moc"
