/*
 * nvview.cpp
 *
 *  Copyright (C) 2007 Jürgen Heinemann <undefined(AT)users(DOT)berlios(dot)de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qfile.h>
#include <qtextstream.h>

#include <kdialog.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstandarddirs.h>

#include "nvview.h"

nvview::nvview( QWidget *parent, const char *name )
                : KCModule( parent, name )
{
        setCaption( trUtf8( "nvidia card" ) );

        QString qhi( trUtf8( "This information is contained in several files in /proc/driver/nvidia." ) + "<br>" );
        qhi.append( "<ul><li><b>" + trUtf8( "agp status" ) + "</b>: " + trUtf8( "The current AGP status." ) + "</li>" );
        qhi.append( "<li><b>" + trUtf8( "kernel modul" ) + "</b>: " + trUtf8( "information about each of the installed NVIDIA Kernel modul parameters" ) + "</li>" );
        qhi.append( "<li><b>" + trUtf8( "agp card" ) + "</b>: " + trUtf8( "Information about the installed AGP card's AGP capabilities." ) + "</li>" );
        qhi.append( "<li><b>" + trUtf8( "agp host bridge" ) + "</b>: " + trUtf8( "Information about the host bridge (model and AGP capabilities)." ) + "</li>" );
        qhi.append( "<li><b>" + trUtf8( "card*" ) + "</b>: " + trUtf8( "Provide information about each of the installed NVIDIA graphics adapters (model name, IRQ, BIOS version, Bus Type)." ) + "</li></ul>" );
        setQuickHelp( qhi );
        setButtons( KCModule::Help );

        QVBoxLayout *box = new QVBoxLayout( this, 0, KDialog::spacingHint() );
        m_view = new nvviewwidget( this, "TabWidgets" );
        box->addWidget( m_view );

}

nvview::~nvview()
{}

// ------------------------------------------------------------------------

extern "C"
{
        KDE_EXPORT KCModule *create_nvview(QWidget *parent, const char *name) {
                KGlobal::locale()->insertCatalogue("kcmnvview");
                return new nvview( parent, name );
        }
}

#include "nvview.moc"
