/*
 * Copyright 2010 Jörg Ehrichs <joerg.ehichs@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tabletsettings.h"
#include "tabletapplet.h"

//KDE includes
#include <KDE/KConfigDialog>
#include <KDE/KGlobal>
#include <KDE/KStandardDirs>
#include <KDE/KCModuleProxy>
#include <KDE/KCModuleInfo>
#include <KDE/KDebug>

//Qt includes
#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusReply>
#include <QtGui/QGraphicsSceneContextMenuEvent>

using namespace Wacom;

static const char DEFAULT_ICON_NAME[] = "input-tablet";

K_EXPORT_PLASMA_APPLET(tabletsettings, TabletSettings)

TabletSettings::TabletSettings(QObject *parent, const QVariantList &args)
        : Plasma::PopupApplet(parent, args),
        m_applet(0),
        m_settingsWidget(0),
        m_tabletInterface(0)
{
    KGlobal::locale()->insertCatalog("tablet");

    setBackgroundHints(StandardBackground);
    setAspectRatioMode(Plasma::IgnoreAspectRatio);

    // let's initialize the widget
    setMinimumSize(graphicsWidget()->minimumSize());
}

TabletSettings::~TabletSettings()
{
    delete m_applet;
}

void TabletSettings::init()
{
    setPopupIcon(DEFAULT_ICON_NAME);

    if (!m_applet) {
        m_applet = new TabletApplet(this);
    }

    //DBus init and connection signal/slot stuff
    m_tabletInterface = new QDBusInterface("de.etricceline.Tablet", "/Tablet", "de.etricceline.Tablet");

    if (!m_tabletInterface->isValid()) {
        m_applet->showError(i18n("DBus connection to the kded deamon not available!\n\nPlease start the wacom tablet deamon and try again.\nThe deamon is responsible for tablet detection and profile support."));
    } else {
        //DBus signals
        connect(m_tabletInterface, SIGNAL(tabletAdded()), SLOT(onTabletAdded()));
        connect(m_tabletInterface, SIGNAL(tabletRemoved()), SLOT(onTabletRemoved()));
        connect(m_tabletInterface, SIGNAL(profileChanged(const QString)), m_applet, SLOT(setProfile(const QString)));

        QDBusReply<bool> isAvailable = m_tabletInterface->call("tabletAvailable");
        if (!isAvailable) {
            m_applet->showError(i18n("No tablet device was found!\n\nPlease connect the device before you start this module.\nIf the device is already connected refer to the help file for any further information."));
        } else {
            m_applet->connectDBus();
            m_applet->showApplet();
        }
    }

}

QGraphicsWidget *TabletSettings::graphicsWidget()
{
    if (!m_applet) {
        m_applet = new TabletApplet(this);
    }

    return m_applet->dialog();
}

void TabletSettings::createConfigurationInterface(KConfigDialog *parent)
{
    m_settingsWidget = new KCModuleProxy("kcm_tablet");

    parent->addPage(m_settingsWidget, m_settingsWidget->moduleInfo().moduleName(),
                    m_settingsWidget->moduleInfo().icon());

    parent->setButtons(KDialog::Ok | KDialog::Cancel);
    connect(parent, SIGNAL(okClicked()), this, SLOT(configAccepted()));
}

void TabletSettings::configAccepted()
{
    //Save the configurations of the embedded KCMs
    m_settingsWidget->save();
    m_applet->updateProfile();
}

void TabletSettings::onTabletAdded()
{
    setPopupIcon(DEFAULT_ICON_NAME);

    m_applet->showApplet();
}

void TabletSettings::onTabletRemoved()
{
    //@todo change icon when tablet is removed
    KIcon icon("input-tablet");
    setPopupIcon(icon);

    m_applet->showError(i18n("No tablet device was found!\n\nPlease connect the device before you start this module.\nIf the device is already connected refer to the help file for any further information."));
}

