/***************************************************************************
                          stringmultilinedlg.cpp  -  description
                             -------------------
    begin                : Wed Jun 28 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "stringmultilinedlg.h"
#include <vector>
#include <string>

StringMultiLineDlg::StringMultiLineDlg(QWidget *parent, const char *name, KCoverPage *page, KCoverMultiString * str, QPoint pos)
 : QDialog(parent,name,true)
{
	initDialog();
	
	// initialize some variables
	TheString = str;
	ThePage = page;
	Pos = pos;
	if (str)
		{
		TextColorButton->setColor(*str->textcolor);
		BackColorButton->setColor(*str->backcolor);
		TransparentBackground->setChecked(str->transparentbackground);
		BackColorButton->setEnabled(!str->transparentbackground);
		for (unsigned int i=0;i<TheString->Text.size();i++)
		{
		    if ( TheString->Text[i]==QString("") )
			MultiLine->insertLine("\n");
		    else 
			MultiLine->insertLine(TheString->Text[i].latin1());
		}
		TheFont = *TheString->Font->Font;
		Alignement = TheString->alignoption;
		switch (TheString->alignoption)
			{
			case ALIGN_LEFT :
				QButtonGroup_1->setButton(0);
				break;
			case ALIGN_CENTER :
				QButtonGroup_1->setButton(1);
				break;
			case ALIGN_RIGHT :
				QButtonGroup_1->setButton(2);
				break;
			}
		InterString->setValue( TheString->Pixel_Separator );
		}
	else
		{
		TextColorButton->setColor(Qt::black);
		BackColorButton->setColor(Qt::white);
		TransparentBackground->setChecked(true);
		BackColorButton->setEnabled(false);
		QButtonGroup_1->setButton(0);
		Alignement = ALIGN_LEFT;
		InterString->setValue( SEPARATOR_PIXEL_STRING );
		}
	
	QObject::connect( OkButton, SIGNAL(clicked()), this, SLOT(CmOk()) );
	QObject::connect( CancelButton, SIGNAL(clicked()), this, SLOT(reject()) );
	QObject::connect( FontButton, SIGNAL(clicked()), this, SLOT(slotFontSelect()) );	
	QObject::connect( TransparentBackground, SIGNAL(clicked()), this, SLOT(CmTransparent()) );
	QObject::connect( LeftRadioButton, SIGNAL(clicked()), this, SLOT(CmLeft()) );
	QObject::connect( CenterRadioButton, SIGNAL(clicked()), this, SLOT(CmCenter()) );
	QObject::connect( RightRadioButton, SIGNAL(clicked()), this, SLOT(CmRight()) );	
}

/*StringMultiLineDlg::~StringMultiLineDlg()
{
}*/

/** user press ok */
void StringMultiLineDlg::CmOk()
{
	std::vector<QString> txt;
	
	for ( int n=0;n<MultiLine->numLines();n++ )
	{
		txt.push_back( QString( MultiLine->textLine(n) ) );
	}

	if ( TheString )
		{
		TheString->Text = txt;
		*TheString->backcolor = QColor( BackColorButton->color() );
		*TheString->textcolor = QColor( TextColorButton->color() );
		TheString->transparentbackground = TransparentBackground->isChecked();
		if (TheString->Font->Font)
			delete TheString->Font->Font;
		TheString->Font->Font = new QFont(TheFont);
		TheString->alignoption = Alignement;
		TheString->Pixel_Separator = InterString->value();
		TheString->info_valid = false;
		}
	else
		{
		TheString = new KCoverMultiString( txt, Pos.x(), Pos.y(), 0 );
		TheString->backcolor = new QColor( BackColorButton->color() );
		TheString->textcolor = new QColor( TextColorButton->color() );
		TheString->transparentbackground = TransparentBackground->isChecked();
		if (TheString->Font->Font)
			delete TheString->Font->Font;
		TheString->Font->Font = new QFont(TheFont);
		TheString->alignoption = Alignement;
		TheString->Pixel_Separator = InterString->value();
		TheString->info_valid = false;
		ThePage->AddMultiString(TheString);
		}
	
	accept();
}

/** select the font */
void StringMultiLineDlg::slotFontSelect()
{
     KFontDialog fontdlg(this, i18n("Select Font"), false, true);
     fontdlg.setFont(TheFont);
     int result = fontdlg.exec();
     if ( result == KFontDialog::Accepted )
		TheFont = fontdlg.font();
}

/** user press the transparent button */
void StringMultiLineDlg::CmTransparent()
{
	BackColorButton->setEnabled(!TransparentBackground->isChecked());
}

/** align option selected */
void StringMultiLineDlg::CmAlignRadio(int button)
{
	switch (button)
		{
		case 1 :
			Alignement = ALIGN_LEFT;
			break;
		case 2 :
			Alignement = ALIGN_CENTER;
			break;
		case 3 :
			Alignement = ALIGN_RIGHT;
			break;
		}
}

void StringMultiLineDlg::CmLeft()
{
	Alignement = ALIGN_LEFT;
}

void StringMultiLineDlg::CmCenter()
{
	Alignement = ALIGN_CENTER;
}

void StringMultiLineDlg::CmRight()
{
	Alignement = ALIGN_RIGHT;
}

