/***************************************************************************
                psocket.h  -  implement a TCP/IP socket wrapper class
                             -------------------
    begin                : Thu May 17 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PSOCKET_H
#define PSOCKET_H

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string>
#include <netdb.h>
#include <ctype.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <sys/time.h>
#include <sys/types.h>
#include <signal.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <qstring.h>

/**
  *@author Pascal 'PeP' Panneels
  */

typedef
    enum { CONNECTED, NOT_CONNECTED, ERROR, ERROR_SOCKET, ERROR_HOSTBYNAME, ERROR_CONNECT }
    StateType;

class PSocket
{
public: 
	PSocket();
	~PSocket();
  	/** write a block of data of maximum len bytes */
  	int writeBlock(char * buffer, int len);
  	/** read a block of data of maximum maxlen chars */
  	int readBlock(char * buffer, int maxlen);
  	/** disconnect (close) a connexion */
  	int disconnect();
  	/** connect to a host / port */
  	int connectToHost(const QString host, const unsigned short int port);

private :
    QString Host;					// the host name to connect to...
    unsigned short int Port;		// the port to connect to...
    int sockfd;						// the connexion socket
    struct hostent *he;         	// for the gethostbyname() function
    struct sockaddr_in server_addr;	// connector's address information
    StateType State;				// state of the connexion
    FILE * sk;						// file stream associated to the socket
};

#endif
