/***************************************************************************
                          kcoverstring.cpp  -  description
                             -------------------
    begin                : Mon Apr 3 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcoverstring.h"
#include <qfontmetrics.h>

KCoverString::KCoverString(QString text, int x, int y, int order )
: KCoverObject( x, y, order )
{
	Text = QString( text.latin1() );
	Font = new KCoverFont((char *)"Helvetica");
	backcolor = new QColor( Qt::white );
	textcolor = new QColor( Qt::black );
	transparentbackground = true;
	alignoption = 1;
}

KCoverString::~KCoverString()
{
	delete Font;
	delete backcolor;
	delete textcolor;
}

KCoverString::KCoverString( const KCoverString &p )
: KCoverObject( p )
{
	Text = QString( p.Text.latin1() );
	Font = new KCoverFont( *p.Font );
	backcolor = new QColor( *p.backcolor );
	textcolor = new QColor( *p.textcolor );
	transparentbackground = p.transparentbackground;
	alignoption = p.alignoption;
}

int KCoverString::operator == (const KCoverString &p) const
{
	if (p.X==X && p.Y==Y && p.Order==Order && p.Text==Text )
		return 1;
	else
		return 0;
}

/** return true if clicked is on a text */
bool KCoverString::IsPointInObject(QPoint &pos)
{
	QFontMetrics fm(*Font->Font);
	int W = fm.width(Text.latin1());
	int H = fm.height();
	
	if ( pos.x()>=X && pos.x()<=X+W && pos.y()<=Y && pos.y()>=Y-H )
		return true;
	else
		return false;
}

int KCoverString::Width()
{
	QFontMetrics fm(*Font->Font);
	return fm.width(Text.latin1());
}

int KCoverString::Height()
{
	QFontMetrics fm(*Font->Font);
	fm.width(Text.latin1());
	return fm.height();
}

int KCoverString::RealX()
{
	QFontMetrics fm(*Font->Font);
	QRect r = fm.boundingRect(Text.latin1());
	return X+r.x();
}

int KCoverString::RealY()
{
	QFontMetrics fm(*Font->Font);
	QRect r = fm.boundingRect(Text.latin1());
	return Y+r.y();
}

void KCoverString::Paint( QPainter *paint,  QPoint orig)
{
	QPoint pos = QPoint(X,Y)+orig;
	paint->setFont( *Font->Font );
	paint->setPen( *textcolor );
	paint->setBackgroundMode( transparentbackground ? Qt::TransparentMode : Qt::OpaqueMode );
	paint->setBackgroundColor( *backcolor );    		
	//paint.drawText( pos, Text.latin1() );

	if ( Angle!=0.0 )							// test to avoid world matrix transformation
		{
		paint->save();
		QWMatrix m;                             // setup world matrix
		m.translate( pos.x(), pos.y() );
		m.rotate( Angle );
		paint->setWorldMatrix( m, true );		// must be true to combine with current world transformations !
		paint->drawText( 0, 0, Text.latin1() );
		paint->restore();
		}
	else
		paint->drawText( pos, Text.latin1() );		
}

/** Save a string */
void KCoverString::Save(QFile &file)
{
	char tmp[256];
	int r1, g1, b1, r2, g2, b2;
	
	// tag TAG_STRING
	tmp[0] = TAG_STRING;
	file.writeBlock( tmp, 1 );
	// call the base class to save the coordinates
	KCoverObject::Save(file);
	// save colors, alignement, transparent info
	backcolor->rgb( &r1, &g1, &b1 );
	textcolor->rgb( &r2, &g2, &b2 );
	sprintf( tmp,"%c%c%c%c%c%c%c%c", alignoption, transparentbackground, r1, g1, b1, r2, g2, b2 );
	file.writeBlock( tmp,8 );
	// save the font information
	Font->Save( file );	
	// save the text itself
	r1 = Text.length();
	file.writeBlock( (char *)&r1, sizeof(int) );
	file.writeBlock( Text.latin1(), r1 );
}

/** load an object */
void KCoverString::Load(QFile &file, int version)
{
	char tmp[256];
	int r1;
	int err;
	
	err = file.readBlock( tmp, 1 );
	if ( tmp[0]!= TAG_STRING )
		return; // error : not a string
	KCoverObject::Load(file, version);
	err = file.readBlock( tmp, 8 );
	alignoption = tmp[0];
	transparentbackground = tmp[1];
	backcolor = new QColor( (unsigned char)tmp[2], (unsigned char)tmp[3], (unsigned char)tmp[4] );
	textcolor = new QColor( (unsigned char)tmp[5], (unsigned char)tmp[6], (unsigned char)tmp[7] );
	
	Font = new KCoverFont( (char *)"Helvetica" );
	Font->Load(file,version);	
	err = file.readBlock( (char *)&r1, sizeof(int) );
	err = file.readBlock( tmp, r1 );
	tmp[r1] = 0;
	Text = QString( tmp );
}

const int KCoverString::GetTopAlignDelta()
{
	return GetBottomAlignDelta();
}

const int KCoverString::GetBottomAlignDelta()
{
	QFontMetrics fm(*Font->Font);
	QRect r = fm.boundingRect(Text.latin1());
	return r.height();
}


const int KCoverString::GetMiddleAlignDelta()
{
	QFontMetrics fm(*Font->Font);
	QRect r = fm.boundingRect(Text.latin1());
	return r.height()/2;
}

void KCoverString::SetText(QString p)
{
	Text = QString( p.latin1() );
}

/** return the text buffer */
const QString KCoverString::text()
{
	return Text;
}

