/***************************************************************************
                          kcoverpage.h  -  description
                             -------------------
    begin                : Sat Apr 15 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVERPAGE_H
#define KCOVERPAGE_H

#include <kcoverobject.h>
#include <kcoverimage.h>
#include <kcoverstring.h>
#include <kcovercurvedstring.h>
#include <kcovermultistring.h>
#include <kcoverbackground.h>
#include <list>
#include <algorithm>
#include <qfile.h>
#include <qcolor.h>
#include <align.h>

/**Base class for the front and the back pages
  *@author Pascal 'PeP' Panneels
  */

class KCoverPage
{
public: 
  /** constructor / destructor */
  KCoverPage();
  virtual ~KCoverPage();
  	
  /** return a pointer to the clicked object */
  KCoverObject * GetSelectedObject(QPoint &);
  /** add an image to the list */
  void AddImage(KCoverImage *img);
  /** return the image #i of the list */
  KCoverImage * GetImage(int i);
  /** Erase the selected object */
  void DeleteSelectedObject(KCoverObject *obj);
  /** Sort the image list */
  void SortImages();
  /** add a string */
  void AddString(KCoverString *str);
  /** return the string number i */
  KCoverString * GetString(int i);
  /** sort the string list */
  void SortStrings();
  /** clear the page content */
  virtual void Clear();
  /** add a curved string to the page */
  void AddCurvedString(KCoverCurvedString *str);
  /** return the curved string number i */
  KCoverCurvedString * GetCurvedString(int i);
  /** sort the curved string list */
  void SortCurvedStrings();
  /** add a multi string to the page */
  void AddMultiString(KCoverMultiString *str);
  /** return the multi string number i */
  KCoverMultiString * GetMultiString(int i);
  /** sort the multi string list */
  void SortMultiStrings();
  /** save the page */
  virtual bool Save(QFile &file, int pagenumber);
  /** load a page */
  virtual void Load(QFile &file, int version);
  /** paint the page */
  virtual void Paint(QPainter *paint, QPoint orig);
  /** draw the frame border (page bordrer) */
  virtual void DrawLayout(QPainter *paint, QPoint orig);
  /** draw the images */
  virtual void DrawImages(QPainter *paint, QPoint orig);
  /** draw the texts */
  virtual void DrawTexts(QPainter *paint, QPoint orig);
  /** draw the curved texts */
  virtual void DrawCurvedTexts(QPainter *paint, QPoint orig);
  /** draw the multi line texts */
  virtual void DrawMultiStrings(QPainter *paint, QPoint orig);
  /** check if a given point is in the page or not  */
  virtual bool IsPointInPage(QPoint ClickedPos);
  /** compute the object position for a specified alignement */
  virtual void AlignObject( KCoverObject * obj, const int halign, const int valign );
  /** return the page width in pixels */
  virtual const unsigned int GetPageWidth() const;
  /** return the page height in pixels */
  virtual const unsigned int GetPageHeight() const;
  /** return the page left margin position */
  virtual const unsigned int GetPageLeftMargin() const;
  /** return the page right margin position */
  virtual const unsigned int GetPageRightMargin() const;
  /** return the last inserted KCoverString */
  virtual KCoverString * GetLastString();

public :
	std::list<KCoverImage *> Images;
	std::list<KCoverString *> Strings;
	std::list<KCoverCurvedString *> CurvedStrings;
	std::list<KCoverMultiString *> MultiStrings;
	int NumberOfObjects;
	bool PageToPrint;
	QColor PageColor;
	KCoverBackground Background;
	bool IsRoundPage;
};

#endif
