/***************************************************************************
                          kcoverimage.h  -  description
                             -------------------
    begin                : Mon Apr 3 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVERIMAGE_H
#define KCOVERIMAGE_H

#include <qimage.h>
//#include <qimageio.h>
#include <qjpegio.h>
#include <qpngio.h>
#include <qpixmap.h>
#include <kcoverobject.h>

/**contains images to place on the cover
  *@author Pascal 'PeP' Panneels
  */

class KCoverImage : public KCoverObject
{
public:
	KCoverImage() {};
	KCoverImage(const char * filename, int x, int y, int order);
	KCoverImage(const KCoverImage &p );
	//~KCoverImage();
    	
  	virtual int GetClassType() {return TYPE_CLASS_IMAGE;} ;	
 	/** return true if POS is in the image */
  	virtual bool IsPointInObject(QPoint &pos);
  	virtual int Width();
  	virtual int Height();
  	virtual void Paint(QPainter *, QPoint);
  	virtual void Paint(QPainter *, QPoint, int W, int H, int SX=0, bool RoundPage=false, bool DrawBorder=true );
  	/** operator == for the comparison function */
  	int operator == (const KCoverImage &p) const;
  	/** load an object */
  	virtual void Load(QFile &file, int version);
  	/** save an object */
  	virtual void Save(QFile &file);
  	/** toggle the movable state */
  	void ToggleTiled();
  	/** scale the image */
  	void Scale( int fx, int fy );
  	/** toggle the transparency */
  	void ToggleTransparency();
  	/** enable/disable transparency */
  	void SetTransparency(bool t);
	
public :
	QImage Image;
	QPixmap ImageAsPixmap;
	bool DrawTiled;
	bool KeepTransparency;
	int SaveX, SaveY;
	int RectW, RectH, SX;
};

#endif
