/***************************************************************************
                          kcoverimage.cpp  -  description
                             -------------------
    begin                : Mon Apr 3 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcoverimage.h"
#include <qpainter.h>
#include <qpoint.h>
#include <qdatastream.h>
#include <qbitmap.h>
#include <stdlib.h>

KCoverImage::KCoverImage(const char * filename, int x, int y, int order) : KCoverObject( x, y, order  )
{
	Image = QImage( filename );		// temporary QImage used to load the file
	ImageAsPixmap.convertFromImage( Image );		// our image is now stored as a QPixmap !
	ImageAsPixmap.setMask( ImageAsPixmap.createHeuristicMask() );
	DrawTiled = false;
	SaveX = SaveY = SX = 0;
	KeepTransparency = true;
}

/*KCoverImage::~KCoverImage()
{
}*/

KCoverImage::KCoverImage(const KCoverImage &p )
: KCoverObject( p )
{
	Image = QImage( p.Image );
	ImageAsPixmap.convertFromImage( Image );
	ImageAsPixmap.setMask( ImageAsPixmap.createHeuristicMask() );
	DrawTiled = p.DrawTiled;
	SaveX = p.SaveX;
	SaveY = p.SaveY;
	SX = p.SX;
	KeepTransparency = p.KeepTransparency;
}

/** return true if POS is in the image */
bool KCoverImage::IsPointInObject(QPoint &pos)
{
	if ( pos.x()>=X && pos.x()<=X+Width() && pos.y()>=Y && pos.y()<=Y+Height() )
		return true;
	else
		return false;
}

int KCoverImage::operator == (const KCoverImage &p) const
{
	if (p.X==X && p.Y==Y && p.Order==Order /*&& p.Image==Image*/ )
		return 1;
	else
		return 0;
}

// this function is obsolete and cannot be used anymore !
void KCoverImage::Paint( QPainter *paint, QPoint orig)
{
	QPoint pos( X+orig.x(), Y+orig.y() );
	paint->drawPixmap( pos, ImageAsPixmap );
}

// if DrawTiled, W and H are the width and height of the rectangle to be filled
void KCoverImage::Paint( QPainter *paint, QPoint orig, int W, int H, int sx, bool RoundPage, bool DrawBorder )
{
	RectW = W;
	RectH = H;
	SX = sx;
	bool PrinterActivated = false;
	QPixmap *bufferpixmap = NULL;
	QPainter * currentpaint = NULL;
	QPoint savedorig = orig;
    	
	// problem : the Postscript doesn't support the raster operation involved here;
	// so we will draw the image in an other contect and map it as a whole to the QPainter
	if ( paint->device()->devType()==QInternal::Printer && RoundPage && DrawTiled )
		{
		PrinterActivated = true;
		bufferpixmap = new QPixmap;
		bufferpixmap->resize( RectW, RectH );
		bufferpixmap->fill( Qt::white );
		currentpaint = new QPainter(bufferpixmap);
		orig = QPoint(0,0);
		}
	else
		currentpaint = paint;
	
	if ( !DrawTiled )
		{
		QPoint pos( X+orig.x(), Y+orig.y() );
    		currentpaint->drawPixmap( pos, ImageAsPixmap );
    		}
    	else
    		{
    		if ( !RoundPage )
			currentpaint->drawTiledPixmap(orig.x()+SX, orig.y(), W, H, ImageAsPixmap );
    		else
    			{
    			// save the current raster operation from the painter
    			Qt::RasterOp savedROP = currentpaint->rasterOp();
    			QBrush savedBrush = currentpaint->brush();
   		  	// draw a filled9 black rectangle around the circle + an inner black circle
   		  	currentpaint->setPen( Qt::black );
	  		currentpaint->setBrush( Qt::black );
  			currentpaint->drawRect( orig.x(), orig.y(), ROUND_BIG, ROUND_BIG );
			currentpaint->setBrush( Qt::white );  			
  			currentpaint->drawEllipse( orig.x(), orig.y(), ROUND_BIG, ROUND_BIG );
  			currentpaint->setBrush( Qt::black );
			currentpaint->drawEllipse( orig.x()+(ROUND_BIG/2)-(ROUND_SMALL/2), orig.y()+(ROUND_BIG/2)-(ROUND_SMALL/2), ROUND_SMALL, ROUND_SMALL );
    			// set raster operation to And
    			currentpaint->setRasterOp( Qt::AndROP );
			// draw the tiled pixmap
			currentpaint->drawTiledPixmap( orig.x()+SX, orig.y(), W, H, ImageAsPixmap );
			// erase the black corner
			currentpaint->setRasterOp( Qt::XorROP );
			// mask the rectangle's borders
			currentpaint->setBrush( Qt::white );
			currentpaint->setPen( Qt::white );
			currentpaint->drawRect( orig.x()+SX, orig.y(), W, H );
			currentpaint->drawEllipse( orig.x(), orig.y(), ROUND_BIG, ROUND_BIG );
			currentpaint->drawEllipse( orig.x()+(ROUND_BIG/2)-(ROUND_SMALL/2), orig.y()+(ROUND_BIG/2)-(ROUND_SMALL/2), ROUND_SMALL, ROUND_SMALL );			
    			if ( DrawBorder )
				{
				currentpaint->setRasterOp( Qt::CopyROP );
				currentpaint->setBrush( Qt::NoBrush );
				currentpaint->setPen( Qt::black );
				currentpaint->drawEllipse( orig.x(), orig.y(), ROUND_BIG, ROUND_BIG );
				currentpaint->drawEllipse( orig.x()+(ROUND_BIG/2)-(ROUND_SMALL/2), orig.y()+(ROUND_BIG/2)-(ROUND_SMALL/2), ROUND_SMALL, ROUND_SMALL );			
    				}
    			// reset the saved raster operation on the painter
			currentpaint->setRasterOp( savedROP );
			currentpaint->setBrush( savedBrush );
			if (PrinterActivated && DrawTiled )
				paint->drawPixmap( savedorig.x()+SX, savedorig.y(), *bufferpixmap);
    		}
    	}
}

/** save an object */
void KCoverImage::Save(QFile &file)
{
	char tmp[20];
	
	// tag TAG_IMAGE
	tmp[0] = TAG_IMAGE;
	tmp[1] = DrawTiled;
	tmp[2] = KeepTransparency;
	file.writeBlock( tmp, 3 );
	// save tiled related informations	
	file.writeBlock((char *)&SaveX, sizeof(int) );
	file.writeBlock((char *)&SaveY, sizeof(int) );
	file.writeBlock((char *)&SX, sizeof(int) );
	// call the base class to save the coordinates
	KCoverObject::Save(file);
	QDataStream s(&file);
	s << Image;
}

/** load an object */
void KCoverImage::Load(QFile &file, int version)
{
	char tmp[20];
	
	// tag TAG_IMAGE
	file.readBlock( tmp, 3 );
	if (tmp[0] != TAG_IMAGE)
		return;
	DrawTiled = tmp[1];
	KeepTransparency = tmp[2];
	// load tiled related informations
	file.readBlock((char *)&SaveX, sizeof(int) );
	file.readBlock((char *)&SaveY, sizeof(int) );
	file.readBlock((char *)&SX, sizeof(int) );
	// call the base class to save the coordinates
	KCoverObject::Load(file, version);
	QDataStream s(&file);
	s >> Image;
	ImageAsPixmap.convertFromImage( Image );		// our image is now stored as a QPixmap !
	if ( KeepTransparency )
		ImageAsPixmap.setMask( ImageAsPixmap.createHeuristicMask() );
}

/** toggle the movable state */
void KCoverImage::ToggleTiled()
{
	DrawTiled^=true;
	IsMovable=!DrawTiled;
	if ( DrawTiled )
		{
		SaveX = X;
		SaveY = Y;
		X = 0+SX;
		Y = 0;
		}
	else
		{
		X = SaveX;
		Y = SaveY;
		}
}

int KCoverImage::Width()
{
	return DrawTiled?RectW:Image.width();
}

int KCoverImage::Height()
{
	return DrawTiled?RectH:Image.height();
}

/** scale the image */
void KCoverImage::Scale( int fx, int fy )
{
	Image = Image.smoothScale( fx, fy );
	SetTransparency( KeepTransparency );
}

/** enable/disable transparency */
void KCoverImage::SetTransparency(bool t)
{
	KeepTransparency = t;
	ImageAsPixmap.convertFromImage( Image );
	if ( t )
		ImageAsPixmap.setMask( ImageAsPixmap.createHeuristicMask() );
	else
		ImageAsPixmap.setMask( QBitmap(0,0) );	// clear the mask
}

/** toggle the transparency */
void KCoverImage::ToggleTransparency()
{
	SetTransparency( !KeepTransparency );
}
