/***************************************************************************
                          kcovercurvedstring.cpp  -  description
                             -------------------
    begin                : Sun Jun 18 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcovercurvedstring.h"
#include <math.h>

KCoverCurvedString::KCoverCurvedString(QString text, int x, int y, int order, unsigned char type, unsigned int r) :
  KCoverString(text, x, y, order)
{
	//Center = QPoint(x,y);		// now center = pos !
	Radius = r;
	SetType(type);	
}

/*KCoverCurvedString::~KCoverCurvedString()
{
}*/

KCoverCurvedString::KCoverCurvedString( const KCoverCurvedString &p )
: KCoverString( p )
{
	Radius = p.Radius;
	SetType( p.Type );	
}

void KCoverCurvedString::Paint( QPainter *mypainter, QPoint orig )
{
	float alpha = TotalAngle / strlen(Text.latin1());
	float beta  = StartAngle;
	
	mypainter->setFont( *Font->Font );
	mypainter->setPen(*textcolor);
	mypainter->setBackgroundMode(transparentbackground ? Qt::TransparentMode : Qt::OpaqueMode );
	mypainter->setBackgroundColor(*backcolor);    		
	
	QPoint a = QPoint(X,Y)+orig;
	//mypainter.drawEllipse( a.x()-Radius, a.y()-Radius, 2*Radius, 2*Radius );
	
	for ( unsigned int i=0; i<strlen(Text.latin1()); i++ )
		{
		// save the coordinates system parameters
		//------------------------------------------------------
		mypainter->save();
		
		float gamma = beta * 3.14159 / 180.0; 	// convert deg->rad

		QPoint b = QPoint( Radius*cos(gamma), Radius*sin(gamma) );

		QWMatrix m;                             // setup world matrix
		m.translate( (float)a.x()+b.x(), (float)a.y()+b.y() );

		if (Type!=TYPE_RAINBOW_DOWN)
			m.rotate( alpha+beta+90 );
		else
			m.rotate( 270+(alpha+beta) );		
		mypainter->setWorldMatrix( m, true );			// must be true to combine with current world transformations !
		mypainter->drawText( 0,0, Text.mid(i,1), 1 );
		if (Type!=TYPE_RAINBOW_DOWN)		
			beta += alpha;
		else
			beta -= alpha;		
		//------------------------------------------------------		
		// restore the previous coordinates system parameters
		mypainter->restore();
		}
}

/** set the type of the curved */
void KCoverCurvedString::SetType(unsigned char type)
{
	Type = type;
	switch ( Type )
		{
		case TYPE_RAINBOW_UP :
			StartAngle = -180.0;
			TotalAngle = 180.0;
			break ;
		case TYPE_RAINBOW_DOWN :
			StartAngle = -180.0;
			TotalAngle = 180.0;
			break ;
		case TYPE_CIRCLE :
			StartAngle = -180.0;
			TotalAngle = 360.0;
			break ;
		}
}

/** return true if clicked is on a text */
bool KCoverCurvedString::IsPointInObject(QPoint &pos)
{
	QFontMetrics fm(*Font->Font);
	int H = fm.height();
	
	double distance = sqrt( pow( pos.x()-X , 2 ) + pow( pos.y()-Y , 2 ) );
	
	switch (Type)
		{
		case TYPE_RAINBOW_UP :
        	if ( Radius-fm.descent()<=distance && distance<=Radius+H && pos.y()<=Y )
				return true;
			else
				return false;
		case TYPE_RAINBOW_DOWN :
        	if ( Radius-fm.descent()<=distance+H && distance<=Radius && pos.y()>=Y )
				return true;
			else
				return false;
		case TYPE_CIRCLE :
			if ( Radius-fm.descent()<=distance && distance<=Radius+H )
				return true;
			else
				return false;
		}
	return false;
}

int KCoverCurvedString::Width()
{
	QFontMetrics fm(*Font->Font);
	return (fm.height()+Radius)*2;
}

int KCoverCurvedString::Height()
{
	QFontMetrics fm(*Font->Font);
	
	switch (Type)
		{
		case TYPE_RAINBOW_UP :
		case TYPE_RAINBOW_DOWN :
			return Radius+fm.height();		
		case TYPE_CIRCLE :
			return 2*(Radius+fm.height());
		}	
	return false;
}

int KCoverCurvedString::RealX()
{
	QFontMetrics fm(*Font->Font);
	return X-Radius-fm.height();
}

int KCoverCurvedString::RealY()
{
	QFontMetrics fm(*Font->Font);
	if ( Type!=TYPE_RAINBOW_DOWN )
		return Y-Radius-fm.height();
	else
		return Y;
}

/** save an object */
void KCoverCurvedString::Save(QFile &file)
{
	char tmp[10];
	
	// tag TAG_STRING
	tmp[0] = TAG_CURVED_STRING;
	file.writeBlock( tmp, 1 );
	// call the base class to save the coordinates
	KCoverString::Save(file);
	// radius
	file.writeBlock( (char *)&Radius, sizeof(int));
	// Type
	file.writeBlock( (char *)&Type, sizeof(char));
	// startangle
	file.writeBlock( (char *)&StartAngle, sizeof(float));
	// stepangle
	file.writeBlock( (char *)&StepAngle, sizeof(float));
	// totalangle
	file.writeBlock( (char *)&TotalAngle, sizeof(float));

}

/** load an object */
void KCoverCurvedString::Load(QFile &file, int version)
{
	int err;
    char tmp[10];
		
	err = file.readBlock( tmp, 1 );
	if ( tmp[0]!= TAG_CURVED_STRING )
		return; // error : not a string
	KCoverString::Load(file, version);
	// radius
	err = file.readBlock( (char *)&Radius, sizeof(int));
	// Type
	err = file.readBlock( (char *)&Type, sizeof(char));
	// startangle
	err = file.readBlock( (char *)&StartAngle, sizeof(float));
	// stepangle
	err = file.readBlock( (char *)&StepAngle, sizeof(float));
	// totalangle
	err = file.readBlock( (char *)&TotalAngle, sizeof(float));

}
