/***************************************************************************
                          kcoverbody.h  -  description
                             -------------------
    begin                : Wed Jul 19 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVERBODY_H
#define KCOVERBODY_H

#include "kdirtree.h"
#include <qpainter.h>
#include <kcoverpage.h>
#include <kcoverfont.h>

/**hold the body informations (directory structure ...)
  *@author Pascal 'PeP' Panneels
  */

class KCoverBody
{
public: 
	KCoverBody( QWidget * parent, char * , int, int, int , bool, bool, bool );
	~KCoverBody();
	void Paint( QPainter *, int page, int TopX, int TopY, KCoverPage &ReferencedPage );
  /** load the body */
  void Load(QFile &file, int version);
  /** save the body */
  void Save(QFile &file);
  /** construct the result tree according to the levels */
  void BuildResultTree();

public :
  /** Access to directories structure */
  KDirTree * myDirTree;
  /** number of columns to display in the body */
  int Columns;
  /**  number of directory levels to scan */
  int Levels;
  /** path to the source directory to scan */
  char SourceCD[250];
  /** Body font to use */
  KCoverFont * BodyFont;
  /** first page to insert the body */
  int BodyPage;
  /** draw or not lines separator in the body */
  bool BodyLined;
  /** user will page number displayed */
  bool DisplayPageNumber;
  /** true if we have to draw the tree lines */
  bool BodyTreeLine;
  /** mark all the pages where the body lies to be printed */
  void MarkPagesToPrint( KCoverPage &BackPage, std::vector<KCoverPage> &FrontPages );

};

#endif
