/***************************************************************************
                          cddbmatchcddlg.cpp  -  description
                             -------------------
    begin                : Thu May 24 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "cddbmatchcddlg.h"

CDDBMatchCDDlg::CDDBMatchCDDlg(DiscContent &cdcontent, QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	char buffer[256];
	
	initDialog();
	// connect the two buttons
	QObject::connect(OkButton, SIGNAL(clicked()), this, SLOT(accept()) );
	QObject::connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()));
	
	// fill the multiedit zone (set as readonly)
	EditZone->insertLine( QString(cdcontent.Artist)+QString(" / ")+QString(cdcontent.Head.DiscTitle) );
	EditZone->insertLine( "" );
	for ( unsigned int i=0;i<cdcontent.Tracks.size();i++ )
		{
		sprintf(buffer,"%.02d. %s", i+1, (cdcontent.Tracks[i]).latin1() );
		EditZone->insertLine( buffer );
		}
}

CDDBMatchCDDlg::~CDDBMatchCDDlg()
{
}
