/***************************************************************************
                          cddb.h  -  description
                             -------------------
    begin                : Thu May 17 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDDB_H
#define CDDB_H

#include <psocket.h>
#include <vector>
#include <string>
#include <qobject.h>
#include <qstring.h>

/**implement the CDDB protocol
  *@author Pascal 'PeP' Panneels
  */

typedef
 	enum { CDDB_NATIVE, CDDB_OVER_HTTP, CDDB_OVER_EMAIL }		// the different transport protocol of CDDB
 	CDDB_ProtocolType;											// 18/05/2001 : CDDB_NATIVE without proxy and without SOCKS only for now.
 	
typedef
	enum { C1xx, C20x, C21x, C22x, C23x, C3xx, C40x, C41x, C43x, C50x, C51x, C53x, UNKNOWN_2, UNKNOWN_3, UNKNOWN_4, UNKNOWN_5, UNKNOWN }	// answers from the server (generic codes returns)
	CDDB_Answer;

typedef
	enum { EXACT_MATCH, INEXACT_MATCH, NO_MATCH, CONNECT_ERROR }
	CDDB_QueryReturnType;
	
// a disc entry in the cddb database
class DiscDBEntry
{
	public :
		// constructor
		DiscDBEntry( QString s1=QString(""), QString s2=QString(""), QString s3=QString("") );
		DiscDBEntry( const DiscDBEntry &p );
		void Clear();
				
	public :
	        QString Category;		// example : rock
		QString DiscID;			// the DiscID
		QString DiscTitle;		// the CD album title
};

typedef std::vector<DiscDBEntry> MatchedEntries;

// a disc content class container
class DiscContent
{
	public :
		// constructor
		DiscContent();
		DiscContent( const DiscContent & p);
		~DiscContent();
		void Clear();
		
	public :
		DiscDBEntry Head;
		QString Artist;			// the artist name
		std::vector<QString> Tracks;	// the different tracks
};


// the CDDB protocol handle class
class CDDB : public QObject
{
	Q_OBJECT

signals: // Signals
  /** signal for an update of the status text */
  void statusText( char * txt );

public:
	// constructor and destructor
	CDDB( CDDB_ProtocolType=CDDB_NATIVE );
	~CDDB();
	
	/** set the server name/port to use */
	void setServerPort( QString server, unsigned short int port=888 );
	/** query the server for a specific CD */
	CDDB_QueryReturnType query( QString DiscID, unsigned int nrtracks, std::vector<int> trackoffsets, int nsecs);
	/** return the response code from the cddb server to a request (decode the code in the passed string)*/
	CDDB_Answer getCDDBResponseCode(char * answer);
	/** return the disc content */
	DiscContent & getDiscContent();
	/** return the matched entries; */
	MatchedEntries & getMatchedEntries();
	CDDB_Answer read( QString cat, QString discid);// read a cd content	
		
private :
	PSocket thesock;							// socket used to communicate to server
	CDDB_ProtocolType Protocol;					// protocol used (native, email or http)
	QString CDDBServer;							// name of the cddb server
	unsigned short int CDDBPort;				// port to access the cddb server
    bool Connected;								// true if we are connected to the cddb server
	char * Command;								// command strings passed to the cddb server
    unsigned int ReturnedCode;					// code returned by the cddb server
    MatchedEntries CloseMatches;				// if inexact matchin, store the close matches here
    DiscContent CDContent;						// the cd disc content
	char msg[512];
	    		
protected :
	CDDB_Answer hello();						// intial client-server handshake (hello command)
	void quit();								// disconnect from the cddb server (quit command)
	bool connect();								// connect the socket to access the cddb server		
};

#endif
