/***************************************************************************
                          backgrounddialog.cpp  -  description
                             -------------------
    begin                : Mon Apr 16 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "backgrounddialog.h"
#include <klocale.h>

BackgroundDialog::BackgroundDialog(KCoverBackground * back, QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	theback = back;
	initDialog();

	setFixedSize(size());
	
	// setup the dialog box title
	setCaption(i18n("Page background color"));
	
	// setup the mode combobox
	ModeCombo->insertItem(i18n("Vertical Gradient"));
	ModeCombo->insertItem(i18n("Horizontal Gradient"));
	ModeCombo->insertItem(i18n("Diagonal Gradient"));
	ModeCombo->insertItem(i18n("Cross Diagonal Gradient"));
	ModeCombo->insertItem(i18n("Pyramid Gradient"));
	ModeCombo->insertItem(i18n("Rectangle Gradient"));
	ModeCombo->insertItem(i18n("Pipe Cross Gradient"));
	ModeCombo->insertItem(i18n("Elliptic Gradient"));
	ModeCombo->insertItem(i18n("Flat"));
	if ( !theback->UseFlatMode )
		ModeCombo->setCurrentItem( theback->Mode );
	else
		{
		ModeCombo->setCurrentItem( ModeCombo->count()-1 );
		Color2Button->setEnabled( false );
        }

	// setup the color buttons	
	Color1Button->setColor( theback->Color1 );
	Color2Button->setColor( theback->Color2 );

	// setup signals and slots
	QObject::connect(OkButton, SIGNAL(clicked()), this, SLOT(CmOk()));
	QObject::connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()));
   	QObject::connect(ModeCombo, SIGNAL(highlighted(int)), this, SLOT(CmComboActivated(int)) );

}

void BackgroundDialog::CmOk()
{
	theback->Color1 = Color1Button->color();
	theback->Color2 = Color2Button->color();	
	theback->Mode = KPixmapEffect::GradientType(ModeCombo->currentItem());
	
	if ( theback->Mode == ModeCombo->count()-1 )
		theback->UseFlatMode = true;
	else
		theback->UseFlatMode = false;
	
	accept();
}

void BackgroundDialog::CmComboActivated(int index)
{
	if (index!=ModeCombo->count()-1)
		Color2Button->setEnabled( true );
	else
		Color2Button->setEnabled( false );
}

