/***************************************************************************
                          audiocd.h  -  description
                             -------------------
    begin                : Sat May 19 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AUDIOCD_H
#define AUDIOCD_H

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <string>		
#include <algorithm>
#include <vector>
#include <qobject.h>
#include <qstring.h>

#include <linux/cdrom.h>		// specific to Linux !!! --> must be encapsulated in DEFINE IFDEF to enable compilation on other Un*x platforms...

/**Access all the audio CD functions and compute CDDB DiscID
  *@author Pascal 'PeP' Panneels
  */

typedef std::vector<int> VectorIntType;

class AudioCD : public QObject
{
	Q_OBJECT

signals: // Signals
	/** signal for an update of the status text */
	void statusText( char * txt );

public:
	AudioCD( QString dev="/dev/cdrom");
	~AudioCD();
	
	/** set the cdrom device */
	void setDevice(QString dev);
	/** return the DiscID as a string */
	QString getDiscID();
	/** described in the cddb documentation */
	int cddb_sum(int n);
	/** return the DiscID as an unsigned long */
	unsigned long getDiscIDul();
	/** return the track's offsets vector of int */
	VectorIntType & getTrackOffsets();
	/** return the length in seconds of the CD */
	unsigned long int getTotalLength();
	/** return the number of tracks */
	unsigned int getNumberTracks();

private :
	bool readTOC();
	void computeDiscID();
		
private :
	QString Device;              // device as a Un*x file device (ie: /dev/cdrom)
	QString DiscID;				// CDDB DiscID
	int cdromfd;				// device descriptor of the CDROM
	unsigned int nr_tracks;	   	// # of tracks
	struct cdrom_msf0 TOC[101];	// Table Of Content of the CD (max 99 tracks + lead-out + lead in)
	bool TOCAvailable;          // true when the TOC is available
	unsigned long ulDiscID;		// computed disc id as an unsigned long
	VectorIntType TrackOffsets;	// offsets of each track
	unsigned long CDLength;		// CD length in seconds
};

#endif
