/***************************************************************************
 *   Copyright (C) 2004 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KBSSETISIGNALPLOT_H
#define KBSSETISIGNALPLOT_H

#include <qpixmap.h>
#include <qwidget.h>

#include <setidata.h>

class KBSSETISignalPlot : public QWidget
{
  Q_OBJECT
  public:
    KBSSETISignalPlot(QWidget *parent=0, const char *name=0);
    
    virtual void clearData();
    virtual void setData(const SETIWorkunitHeader &workunit, const SETIGaussian &gaussian);
    virtual void setData(const SETIWorkunitHeader &workunit, const SETIPulse &pulse);
    virtual void setData(const SETIWorkunitHeader &workunit);
    
    virtual QPixmap pixmap();
    
    static const QSize defaultSize, setiSize;
    
  protected:
    virtual void paintEvent(QPaintEvent *event);
    
  private:
    void computeBoundaries(const QValueList<double> &list, double &min, double &max);
    void arrow(QPainter &painter, int x1, int y1, int x2, int y2);

  protected:
    double m_start;
    
    enum {NoData, Gaussian, Pulse, TelescopePath} type;
    SETIGaussian m_gaussian;
    SETIPulse m_pulse;
    SETIDataDesc m_data_desc;
    
    static const unsigned s_margin;
};

#endif
