/***************************************************************************
 *   Copyright (C) 2004 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef EINSTEINDATA_H
#define EINSTEINDATA_H

#include <qdatetime.h>
#include <qmap.h>
#include <qstring.h>
#include <qvaluelist.h>

QDateTime parseGPSDate(int secs);
QDateTime parseGPSDate(const QString &text);
int formatGPSDate(const QDateTime &date);

QString formatRA(double ra);
QString formatDec(double dec, bool sign=true);

struct EinsteinCmdLineArgs
{
  QMap<QString,QString> h[2], out;
  
  bool parse(const QString &input);
};

struct EinsteinConf
{
  unsigned Fthreshold;
  double dFreq,
         FreqBand;
  QString ephemDir;
  double Alpha,
         AlphaBand,
         dAlpha,
         Delta,
         DeltaBand,
         dDelta;
  unsigned gridType;
  QString IFO,
          mergedSFTFile;
          
  bool parse(const QStringList &lines);
};

struct EinsteinMass
{
  QValueList< QValueList<double> > data;
  unsigned count;
  double value;
  
  bool parse(const QStringList &lines);
};

struct EinsteinCoord
{
  double freq,
         ra,
         dec;
};

struct EinsteinH
{
  EinsteinCoord coord;
  double power;
  
  bool parse(const QString &line);
};

struct EinsteinCoincidence
{
  unsigned index[2];
  double coincidence;
  
  bool parse(const QString &line);
};

struct EinsteinPolkaOut
{
  QValueList<EinsteinH> h[2];
  QValueList<EinsteinCoincidence> coincidences;
  
  bool parse(const QStringList &lines);
};

struct EinsteinResult
{
  EinsteinCmdLineArgs args;
  EinsteinConf conf;
  EinsteinMass earth, sun;
  EinsteinPolkaOut polka_out;
};

struct EinsteinFstat
{
  EinsteinCoord coord;
  unsigned count;
  double value[2];
  double power;
  
  bool parse(const QString &line);
};

struct EinsteinState
{
  QValueList<EinsteinFstat> fstats[2];
};

#endif
