/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef PROFILE_LIST_H
#define PROFILE_LIST_H

#include "ui_profilelistbase.h"

namespace KBlogger
{

/**
  @brief
  This class is exposing the list of profiles (blogs). It has te ability
  to add, remove and modify profiles. add and remove open ProfileConfigDialog
  for the concrete configuration of the profile.
*/

class ProfileList : public QWidget, public Ui::ProfileListBase
{
    Q_OBJECT
public:
    ProfileList( QWidget* parent = 0 ); //List entries in upload
    virtual ~ProfileList();

private Q_SLOTS:
    void populateList();
    void addAccount();
    void delAccount();
    void modifyAccount(QString account = QString() );
};

}//namespace
#endif
