/***************************************************************************
   Copyright (C) 2007-2008
   by Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "profileconfig.h"

#include <QtCore/QHash>

#include <kconfig.h>
#include <kglobal.h>
#include <ksharedconfig.h>


namespace KBlogger
{

typedef QHash<QString, ProfileConfig*> DevsHash;
K_GLOBAL_STATIC( DevsHash, mPrefs)

ProfileConfig* ProfileConfig::prefs(const QString &groupName)
{
//     if (!mPrefs)
//     {
//         mPrefs = new Q3Dict<ProfileConfig>();
//         mPrefs->setAutoDelete(true);
//     }
    kDebug() << "ProfileConfig::prefs " << groupName << endl;
    ProfileConfig *profilePrefs = mPrefs->value(groupName, NULL);
    if (profilePrefs) {
//         profilePrefs->readConfig();
        return profilePrefs;
    }

    profilePrefs = new ProfileConfig(groupName);
    profilePrefs->readConfig();
    kDebug() << "ProfileConfig::prefs(" << groupName << ");" << endl;
    return profilePrefs;
}

bool ProfileConfig::hasPrefs(const QString &groupName)
{
    KConfig &config = *KGlobal::config();
    return config.hasGroup(groupName);
}

void ProfileConfig::deletePrefs(const QString &groupName)
{
    KConfig &config = *KGlobal::config();
    config.deleteGroup(groupName);
    if (!mPrefs)
        return;
    mPrefs->remove(groupName);
}


} //namespace
