/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef MEDIA_LIST_H
#define MEDIA_LIST_H

#include "itemlist.h"
#include "ui_medialistbase.h"

#include <QMap>

#include "backend/backend.h"

class QTreeWidgetItem;

namespace KBlogger
{

class Media;
class MainWindow;

class MediaListWidget : public ItemList, public Ui::MediaListBase
{
    Q_OBJECT

public:
    explicit MediaListWidget( const QString& blogname,
                     QWidget* parent = 0 );

    virtual ~MediaListWidget();

    //Appends media in the widget, map and list
    virtual void appendMedia( Media* kbMedia );

    //Returns a ptr to the current selected media in the widget
    Media* getCurrentMedia();

    //Returns the first child of the current item which is the thumbnail here
    Media* getCurrentThumbnail();

    //Returns the number of item stored in the widget (map)
    int count();

protected:
    //Widget Coloumns
    enum coloumns { Name = 0, CreationDate, Size, Status };

    //Store Media ptr sorted by its QTreeWidgetItem ptr.
    QMap<QTreeWidgetItem*, Media*> mMediaMap; //NOTE use QHash?

    //Store Media ptr sorted by creation
    //NOTE: This list should contain media fullsize ptr before its thumbnail.
    QList<Media*> mSortedMediaList;
};


/**
 * MediaList Class
 */
class MediaList : public MediaListWidget
{
    Q_OBJECT
public:
    MediaList( const QString& blogname,
               MainWindow* kbloggerParent,
               QWidget* parent = 0 );

    virtual ~MediaList();

    //
    void appendMedia( Media* kbMedia );

    //Save All media (QList sorted) in a file
    void save();

    //Reads Data from file and creates media
    void load();

    //Update the search Line in the KBlogger class
    void updateSearchLine();

    //Returns a list of media stored in this widget
    QList<Media*> getMediaList();

    //Remove  Media (Polish internal vars and delete local cached copy of the media)
    void removeLocalItem( Media *media = 0 );

    //Add MediaUrl in the ignore List.
    void addToIgnoredMediaUrls(const KUrl &url);

    //Get blacklisted urls
    QStringList getIgnoredMediaUrls();

public Q_SLOTS:
    //Runs MainWindow associated to the mime of the media.
    void openSelectedMedia();

private Q_SLOTS:
    //Shows a preview of the media
    void previewItem();

    //Show a popup over the QTreeWidgetItem of the media
    void showPopup(const QPoint& pos);

private:
    MainWindow *mKblogger;

    //Filename stores the media information
    //it will be saved and loaded by save() and load() functions
    QString mFilename;
    QStringList mIgnoredMediaUrls;
};

}
#endif

