/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef IMPORTMEDIAWIDGET_H
#define IMPORTMEDIAWIDGET_H

#include "ui_importmediawidgetbase.h"
#include "media/media.h"

class KJob;

namespace KBlogger
{

/**
 * This Dialog Import local and remote media in kblogger
 * Some urls cannot be imported (Eg: too big! ), so they are blacklisted.
 * KBlogger save blacklisted imageUrls in a file.
 */

class ImportMediaWidget : public QWidget, public Ui::ImportMediaWidgetBase
{
    Q_OBJECT
public:
    //Costructor
    ImportMediaWidget(QWidget *parent = 0);

    //Default destructor
    virtual ~ImportMediaWidget();

    // adds an imageUrl to the widget if it is not blacklisted, otherwise it returns false
    bool addUrl(const QString& imageUrl, const QString& blogname, const QString& postId);
    // run all jobs to import the media files
    void accept();
    //Clear treeItemList
    void clearList();
    
    //MediaTreeWidget coloumns: see importmediawidgetbase.ui
    enum mediaTreeColoumns{fileName_coloumn=0,
                           url_coloumn,
                           blogName_coloumn,
                           postId_coloumn,
                           status_coloumn};

private Q_SLOTS:
    void handleFileJobResult( KJob* job );

private:
    // created for convenience in handleFileJobResult()
    void jobsFinished();
    //
    void createMediaFromUrl(QTreeWidgetItem*);
    /* 1) Scan mediaMap to find QTreeWidgetItem with a parent (thumbnail QTWI)
     *  and set parent and child media to FullSizeImage and Thumbnail
     * 2) Add all created Media in the MediaListWidget, so they are user visible.
     */
    void processCreatedMedia();
    
    
    //Vars
    KDialog *mParent;
    QList<QTreeWidgetItem*> treeItemList;
    QMap<KJob*,QTreeWidgetItem*> jobsMap;
    QMap<QTreeWidgetItem*,Media*> mediaMap; 
    //N° of blacklisted imageUrls.
    int blackListedUrls;
};

} //namespace

#endif
