/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef MAIN_WIDGET_H
#define MAIN_WIDGET_H

#include <qmap.h>
#include "ui_mainwidgetbase.h"
#include "post/postslist.h"

//class ProfileConfig;
class QStackedWidget;
class QTextBrowser;
class KActionCollection;

namespace KBlogger
{

class Post;
class Media;
class VisualEditor;

/**
 *  TreeIndex Class
 *  Store:
 *  - pos: the Position of the blogname QTreeWidget in the left side BlogList
 *  - widget: the Widget correlated to the QTreeWidgetItem in the left side BlogList
 *  - text: text of the QTreeWidgetItem in the left side BlogList
 */
class TreeIndex
{
public:
    TreeIndex(int pos, QWidget* widget, const QString& text = QString() ) {
        mPos = pos; mWidget = widget; mText = text;
    };
    TreeIndex() {};
    ~TreeIndex() {};

    int pos() {
        return mPos;
    }
    QWidget* widget() {
        return mWidget;
    }
    QString text() {
        return mText;
    }
private:
    //This is the position in the QTreeWidget.
    int mPos;
    //This is the widget that QStack should show when this item is clicked.
    QWidget* mWidget;
    //This is the original text of this QTreeWidgetItem;
    QString mText;
};


/**
 * MainWidget Class
 * It's the main kblogger widget.
 */
class MainWidget : public QWidget, public Ui::MainWidgetBase
{
    Q_OBJECT
    friend class PostsList;
    friend class MediaList;

public:
    //Singleton class
    static MainWidget *self(KActionCollection *actionCollection = 0, QWidget* parent = 0);
    virtual ~MainWidget();

    void viewEntry(Post* post);
    void viewEntry(Media *media);
    void openSelectedMedia();
    KActionCollection* actionCollection() const;

public Q_SLOTS:
    void reloadSettings();
    void saveStatus();

    /*KActions slots*/
    void updateAllSentPostList();
    void trashPost();
    void deletePost();
    void modifyPost();
    void removeLocalMedia();

    void uploadCurrentMedia();
    void uploadCurrentPosts();

    QString currentBlogname(); //Return the blogname of the shown widget

protected:
    void updateItemNumbers();

private Q_SLOTS:
    //read the config and fill the AccountList.
    void populateAccountList();
    //When you click a QTreeWidgetItem in the blog list this func is called.
    void changeShownEntriesList(QTreeWidgetItem *currentItem);
    void updateKActions(int i);

private:
    MainWidget( KActionCollection *actionCollection, QWidget* parent = 0 );
    void initialize();
    void populateWelcomeTextBrowser(QTextBrowser* textBrowser);
    void saveConfig();
    void readConfig();

private:
    static MainWidget *s_self;
    QStackedWidget *stackedWidget;
    QMap<QTreeWidgetItem *, TreeIndex > mQTreeWidgetItemMap;
    MainWindow* mMainWindow;
    KActionCollection *mActionCollection;
    VisualEditor *previewBrowser;

Q_SIGNALS:
    void activated(int); //sent by "Draft" or "Sent" in the blogList
};

}//namespace
#endif
