/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>
   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef ITEMS_MANAGER_H
#define ITEMS_MANAGER_H

#include <QtCore/QObject>

#include <QMap>

/**
 * @author Antonio Aloisio <gnuton@gnuton.org>
 */

class QUrl;

namespace KBlogger
{

class  SentPostsList;
class  LocalDraftPostsList;
class  TrashedPostsList;
class  MediaList;
class  Media;
class  Post;

class ItemsManager : public QObject
{
    Q_OBJECT

public:
    static ItemsManager *self(QObject* parent = 0);
    ~ItemsManager();

    //create a local draft that will be uploaded
    void createNewPost(Post* post);

    //getPost read all the post that will be uploaded in every "Local Draft" widgets
    void enqueuePostsToUpload(const QString& blogname = QString());

    void addInTheWidgetsList( const QString& blogName, LocalDraftPostsList* widget );
    void addInTheWidgetsList( const QString& blogName, SentPostsList* widget);
    void addInTheWidgetsList( const QString& blogName, TrashedPostsList* widget);
    void addInTheWidgetsList( const QString& blogName, MediaList* widget);

    //POSTS: Remove the post from the draft
    void removeDraftPost(Post* kbPost);

    //POSTS: Remove the post from the trash
    void removeTrashedPost(Post* kbPost);

    //POSTS: Add currentUploadItem in the sent QTreeWidget
    void addToSentList(Post* kbPost);

    //POSTS: Add the kbPost in the trash QTreeWidget
    void trashPost(Post *kbPost);

    //POSTS: Move
    void moveDraftToSentList(Post *kbPost);

    //POSTS
    void updatePostsSentList(const QString &blogname);

    //POSTS Check the ID of fetched posts.
    bool isStored(Post *kbPost);

    //POSTS Scans sent posts and put the uncached media ("http://www.yourblog.org/media.xxx") in the mediagetter dialog.
    void getUncachedMediaInThePosts( const QString &blogname );

    //MEDIA: Add the media in the correct QTreeWidget;
    void addMedia( Media *media );

    //MEDIA: Enqueue media in the upload List;
    void enqueueMediaToUpload(const QString& blogname = QString());

    //MEDIA: Returns the url of a media (identified with your data checksum)
    QString url( QString &blogname, quint16 checksum );

    //MEDIA: Returns the data of the url stored in a Media Class.
    QByteArray mediaData(const QUrl &url);

    //MEDIA
    const QList<Media*> getMediaList(const QString& blogname);

    //Insert url in the ignore List, this list will be ignored from ImportMediaDialog Class
    void addToIgnoredMediaUrls(const QUrl &url, const QString& blogname);

    //Get Blacklist media urls
    QStringList getIgnoredMediaUrls( const QString& blogname );


private:
    //default costructor.
    ItemsManager(QObject *parent = 0);
    static ItemsManager *s_self;

    //Map <BlogName,WidgetThatContainsMediaOrPostsOfThisBlogName>
    QMap<QString, LocalDraftPostsList*> localWidgetsList;
    QMap<QString, SentPostsList*> sentWidgetsList;
    QMap<QString, TrashedPostsList*> trashedWidgetsList;
    QMap<QString, MediaList*> mediaWidgetsList;
};

}

#endif
