/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "composer/linkdialog.h"

#include <QRegExp>

#include <klineedit.h>
#include <kdebug.h>
#include <kvbox.h>



namespace KBlogger
{
/** LinkDialog Class **/
LinkDialog::LinkDialog( QWidget *parent):KDialog(parent){
    kDebug();
    mLinkWidget= new LinkWidget(this);
    setCaption( "Add Link" );
    setButtons( KDialog::Ok | KDialog::Cancel );
    setMainWidget( mLinkWidget );

    connect ( this, SIGNAL (  okClicked() ),
              this, SLOT( slotAccept() ));
/*
    connect (mLinkWidget->targetLineEdit, SLOT( textChanged(QString) ),
             this, SIGNAL( slotTargetFilled(QString) ) );
    connect (mLinkWidget->nameLineEdit, SLOT( textChanged(QString) ),
             this, SIGNAL( slotNameFilled(QString) ) );*/
    
    //enableButtonOk( false );
    show();
}

LinkDialog::~LinkDialog(){
    kDebug();
    delete mLinkWidget;
}
/*
void LinkDialog::slotEnableButtonOk( bool state ){
    kDebug();
    enableButtonOk(state);
}

void LinkDialog::slotTargetFilled(QString target){
    kDebug();
    bool state=false;
    if (! mLinkWidget->nameLineEdit->text().isEmpty() ){
        state=true;
    }
    enableButtonOk(state);
    
}

void LinkDialog::slotNameFilled(QString name){
    kDebug();
    bool state=false;
    if (! mLinkWidget->targetLineEdit->text().isEmpty() ){
        state=true;
    }
    enableButtonOk(state);
}
*/
void LinkDialog::setLinkName( const QString &linkName )
{
    if ( linkName.isEmpty() )
        mLinkWidget->nameLineEdit->clear();
    else
        mLinkWidget->nameLineEdit->setText(linkName);//sanitize(linkName));
}
void LinkDialog::slotAccept()
{
    kDebug();
    if ( mLinkWidget->targetLineEdit->text().isEmpty() || 
         mLinkWidget->nameLineEdit->text().isEmpty()    
       ){
         return;
    }
    emit addLink( mLinkWidget->targetLineEdit->text(), mLinkWidget->nameLineEdit->text() );
    //targetLineEdit->setText("http://");
    //nameLineEdit->clear();
    close();
}

/** LinkWidget **/
LinkWidget::LinkWidget(QWidget *parent)
        : QWidget(parent)
{
    setupUi(this);
}

LinkWidget::~LinkWidget(){
    kDebug();
}

} //namespace
#include "linkdialog.moc"
