/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>
   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef WAIT_WIDGET_H
#define WAIT_WIDGET_H

#include "ui_waitwidgetbase.h"
#include <KDialog>

namespace KBlogger
{

/**
  @brief
  This class is the widget for the WaitDialog including a progress bar. 
*/

class WaitWidget : public QWidget, public Ui::WaitWidgetBase
{
    Q_OBJECT
public:
    WaitWidget( QWidget* parent = 0 );
    virtual ~WaitWidget();
    // sets the text in the label
    void setText( const QString& text );
    void jobDone();
    // sets the progress bar's max value
    void setMaxJobs( int );

private:
    static WaitWidget *s_self;
};

} //namespace
#endif

