/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>
   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "backend/waitwidget.h"

#include <kdebug.h>

/**
 *  This widget will be showed when some jobs are running.
 *  WaitWidget informs the user about jobs that are running
 */


namespace KBlogger
{


WaitWidget::WaitWidget(QWidget* parent ): QWidget(parent)
{
    kDebug();
    setupUi(this);
}

WaitWidget::~WaitWidget()
{
    kDebug();
}

void WaitWidget::setText( const QString& text )
{
    kDebug();
    operationNameLabel->setText(text);
}

void WaitWidget::setMaxJobs( int max )
{
    kDebug();
    progressBar->setMaximum( max );
}

void WaitWidget::jobDone()
{
    kDebug();
    progressBar->setValue(progressBar->value()+1);
}

}//namespace

#include "waitwidget.moc"

