/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>
   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef WAIT_DIALOG_H
#define WAIT_DIALOG_H

#include <KDialog>

namespace KBlogger
{

class WaitWidget;

/**
  @brief
  This class is handling the dialog shown when jobs are run from BackendJobQueue.
*/

class WaitDialog : public KDialog
{
    Q_OBJECT
public:
    WaitDialog( int, QWidget* parent = 0 );

    virtual ~WaitDialog();
public Q_SLOTS:
    // update the text in the info label
    void setText( const QString& text );
    // increments the progress bar
    void jobDone();

private:
    WaitWidget* widget;
};

} //namespace
#endif

