/***************************************************************************

   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef BLOGLIST_H
#define BLOGLIST_H

#include <QtCore/QHash>
#include <QtCore/QVariant>
#include <QtCore/QString>
#include <QtCore/QStringList>
 /**
  * @brief
  * BlogList return a List of blog parameters such as api, sitename ecc..
  *
  * Usage:
  *
  *  QList<QHash<QString,QVariant> >  mBlogList;
  *  QString mApi;
  *
  *  mBlogList= blogList();
  *  mApi=mBlogList[ Wordpress_com ][ "api" ];
  *
  */
 enum blogType{ Blogspot, Wordpress_com, LiveJournal_com, Drupal, Wordpress, General };
 QList<QHash<QString,QVariant> > BlogList();

#endif
