/***************************************************************************
 *   Copyright (C) 2005 by Christian Weilbach   *
 *   christian_weilbach@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kbloggerupload.h"

#include <kfiledialog.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kdebug.h>
#include <API_Blog.h>

#include "kbloggerconfigdialog.h"
#include "kbloggerconfig.h"

KBloggerUpload::KBloggerUpload( KBlog::APIBlog* backend, QString& filename, QWidget *parent, const char *name)
    :KBloggerUploadBlank(parent, name)
{
	kdDebug() << "KBloggerUpload::KBloggerUpload()" << endl;
	m_backend=backend;
	m_media=new KBlog::BlogMedia();
	if( !filename.isEmpty() )
		FileLineEdit->setText( filename );

	this->show();
}

KBloggerUpload::~KBloggerUpload(){
	kdDebug() << "KBloggerUpload::~KBloggerUpload()" << endl;
	delete m_media;
}

void KBloggerUpload::uploadSlot(){

	kdDebug() << "KBloggerUpload::uploadSlot()" << endl;

	if( FileLineEdit->text().isEmpty() || NameLineEdit->text().isEmpty() ) {
		KMessageBox::error( 0, i18n( "You have to enter a name and a valid URL." )  );
		return;
	}
	KURL url( FileLineEdit->text() );
	KIO::TransferJob *fileJob = KIO::get( url );

	connect( fileJob, SIGNAL( result( KIO::Job* ) ),
			this, SLOT( handleFileJobResult( KIO::Job* ) ) );
	connect( fileJob, SIGNAL( data( KIO::Job*,  const QByteArray & ) ),
			this, SLOT( handleFileJobData( KIO::Job*,  const QByteArray & ) ) );
	connect( fileJob, SIGNAL( mimetype( KIO::Job*,  const QString & ) ),
			this, SLOT( handleFileJobMimetype( KIO::Job*,  const QString & ) ) );

	this->close();
}

void KBloggerUpload::openSlot(){
	kdDebug() << "KBloggerUpload::openSlot()" << endl;
	FileLineEdit->setText( ( 
			KFileDialog( QString(), QString(), dynamic_cast<QWidget*>(this), "upload", false ) ).getOpenFileName()
	);
}

void KBloggerUpload::handleFileJobData( KIO::Job* job, const QByteArray& data ){
	kdDebug() << "KBloggerUpload::handleFileJobData()"<< data << endl;
	int m_size= ( m_media->data() ).size();
	int size= data.size();
	( m_media->data() ).resize( m_size + size );
	for( int i=0; i< size; i++ ) // FIXME ?
		( m_media->data() )[ m_size + i ] = data[ i ];
}

void KBloggerUpload::handleFileJobMimetype( KIO::Job* job, const QString& mimetype ){
	kdDebug() << "KBloggerUpload::handleFileJobMimetype() mimetype=" << mimetype <<endl;
	m_media->setMimetype( mimetype );
}

void KBloggerUpload::handleFileJobResult( KIO::Job* job ){
	if( job->error() ){
	        job->showErrorDialog();
		return;
	}
	kdDebug() << "KBloggerUpload::handleFileJobResult() got file successfully" << endl;
	m_media->setBlogID( KBloggerConfig::blogId() );
	m_media->setName( NameLineEdit->text() );
	KIO::Job* uploadJob=m_backend->createUploadMediaJob( KURL::KURL( KBloggerConfig::url() ), m_media );
	connect( uploadJob, SIGNAL( result( KIO::Job* ) ),
			m_backend, SLOT( interpretUploadMediaJob( KIO::Job* ) ) );
}
#include "kbloggerupload.moc"
