/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "interface.h"
#include "imagecollection.h"

namespace Plugins
{

Interface::Interface( QObject *parent, const char *name )
        : KIPI::Interface( parent, name )
{
//     connect( Browser::BrowserWidget::instance(), SIGNAL( pathChanged( const QString& ) ), this, SLOT( pathChanged( const QString& ) ) );
}

KIPI::ImageCollection Interface::currentAlbum()
{
//     return KIPI::ImageCollection( new Plugins::ImageCollection( Plugins::ImageCollection::CurrentAlbum ) );
    return KIPI::ImageCollection();
}

KIPI::ImageCollection Interface::currentSelection()
{
//     if ( MainWindow::Window::theMainWindow()->selected().count() != 0 )
//         return KIPI::ImageCollection( new Plugins::ImageCollection( Plugins::ImageCollection::CurrentSelection ) );
//     else
//         return KIPI::ImageCollection(0);
}

QList<KIPI::ImageCollection> Interface::allAlbums()
{
//     QList<KIPI::ImageCollection> result;
//     DB::ImageSearchInfo context = MainWindow::Window::theMainWindow()->currentContext();
//     QString category = MainWindow::Window::theMainWindow()->currentBrowseCategory();
//     if ( category.isNull() )
//         category = Settings::SettingsData::instance()->albumCategory();
//
//     QMap<QString,uint> categories = DB::ImageDB::instance()->classify( context, category, DB::Image );
//
//     for( QMap<QString,uint>::Iterator it = categories.begin(); it != categories.end(); ++it ) {
//         CategoryImageCollection* col = new CategoryImageCollection( context, category, it.key() );
//         result.append( KIPI::ImageCollection( col ) );
//     }
//
//     return result;
}

KIPI::ImageInfo Interface::info( const KUrl& url )
{
//     return KIPI::ImageInfo( new Plugins::ImageInfo( this, url ) );
}

void Interface::refreshImages( const KUrl::List& urls )
{
    emit imagesChanged( urls );
}

int Interface::features() const
{
    return
        KIPI::ImagesHasComments |
        KIPI::ImagesHasTime |
        KIPI::HostSupportsDateRanges |
        KIPI::HostAcceptNewImages |
        KIPI::ImagesHasTitlesWritable;
}

bool Interface::addImage( const KUrl& url, QString& errmsg )
{
//     QString dir = url.path();
//     QString root = Settings::SettingsData::instance()->imageDirectory();
//     if ( !dir.startsWith( root ) ) {
//         errmsg = i18n("<p>Image needs to be placed in a sub directory of your photo album, "
//                       "which is rooted at %1. Image path was %2</p>").arg( root ).arg( dir );
//         return false;
//     }
//
//     dir = dir.mid( root.length() );
//     DB::ImageInfoPtr info( new DB::ImageInfo( dir ) );
//     DB::ImageInfoList list;
//     list.append( info );
//     DB::ImageDB::instance()->addImages( list );
//     return true;
}

void Interface::delImage( const KUrl& url )
{
//     DB::ImageInfoPtr info = DB::ImageDB::instance()->info( url.path() );
//     if ( info ) {
//         QStringList list;
//         list.append( info->fileName() );
//         DB::ImageDB::instance()->deleteList( list );
//     }
}

void Interface::slotSelectionChanged( bool b )
{
    emit selectionChanged( b );
}

void Interface::pathChanged( const QString& path )
{
//     static QString _path;
//     if ( _path != path ) {
//         emit currentAlbumChanged( true );
//         _path = path;
//     }
}

} //namespace

#include "interface.moc"

