/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "linkdialog.h"

#include <QRegExp>

#include <klineedit.h>
#include <kdebug.h>
#include <kvbox.h>



namespace KBlogger
{

KBloggerLinkDialog::KBloggerLinkDialog(QWidget *parent)
        : QDialog(parent)
{
    setupUi(this);
}

void KBloggerLinkDialog::setLinkName(const QString &linkName = 0)
{
    if ( linkName.isEmpty() )
        nameLineEdit->clear();
    else
        nameLineEdit->setText(linkName);//sanitize(linkName));
}


void KBloggerLinkDialog::accept()
{
    kDebug();
    if ( targetLineEdit->text().isEmpty() || nameLineEdit->text().isEmpty()) return;
    emit addLink( targetLineEdit->text(), nameLineEdit->text() );
    //targetLineEdit->setText("http://");
    //nameLineEdit->clear();
    close();
}

void KBloggerLinkDialog::reject()
{
    kDebug();
    close();
}

} //namespace
#include "linkdialog.moc"
