/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/


#ifndef KBLOGGER_BLOG_H
#define KBLOGGER_BLOG_H

#include <kurl.h>
#include "backend.h"

class KIcon;

namespace KWallet
{
class Wallet;
}

namespace KBlogger
{

class KBloggerBlog
{

public:
    KBloggerBlog( );

    ~KBloggerBlog();

    void setBlogname( const QString& blogname );
    QString blogname();

    void setUrl( const QString& url );
    KUrl url();

    void setUsername( const QString& username );
    QString username();

    void setFullName( const QString& fullname );
    QString fullName();

    //void setPassword( const QString& password );
    QString password();

    void setApi( Backend::api_type api);
    Backend::api_type api();

    void setBlogId( const QString& id );
    QString blogId();

    KIcon icon();

private:
    QString mBlogname;
    KUrl    mUrl;
    QString mUsername;
    QString mFullName;
    QString mBlogId;
    Backend::api_type mApi;
    KWallet::Wallet* mWallet;
};

}
; // namespace

#endif

