/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "configdialog.h"

#include <kconfigskeleton.h>
#include <kdebug.h>

#include "profilelist.h"

#include "config-kpa-kipi.h"
#ifdef HASKIPI
#  include "plugins/setupplugins.h"  //KIPI plugins
#endif

namespace KBlogger
{

configDialog::configDialog(QWidget *parent, const QString &name, KConfigSkeleton *config):
        KConfigDialog(parent, name, config),
        mProfileList( new ProfileList(0) )
{
    kDebug();
    addPage(mProfileList, i18n("Account profiles"), "system-users");

#ifdef HASKIPI
    Digikam::SetupPlugins *setupKipiGUI = new Digikam::SetupPlugins(this);
    addPage(setupKipiGUI, i18n("Kipi Plugins"), "digikam");
#endif

    setAttribute( Qt::WA_DeleteOnClose );
    //connect(mProfileList);
    show();
}

configDialog::~configDialog()
{
    kDebug();
    emit settingsChanged(QString());
}

} //namespace
#include "configdialog.moc"
