/***************************************************************************
 *   Copyright (C) 2004-2005 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXWEBQUERYSPIRESHEP_H
#define KBIBTEXWEBQUERYSPIRESHEP_H

#include <webquery.h>

namespace KBibTeX
{

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */

    class WebQueryWizardSpiresHep: public WebQueryWizard
    {
        Q_OBJECT
    public:
        WebQueryWizardSpiresHep( const QString& caption, QWidget* parent, const char* name = 0 );
        ~WebQueryWizardSpiresHep();

    protected slots:
        void startSearch();

    private:
        static const QString mirrorNames[];
        static const QString mirrorURLs[];

    };

    class WebQuerySpiresHep : public WebQuery
    {
    public:
        WebQuerySpiresHep( QWidget* parent, const char* name = 0 );
        ~WebQuerySpiresHep();

        BibTeX::File* query( );

        int uniqueId();
        QString title();

    private:
        WebQueryWizardSpiresHep *m_wizard;

    };

}

#endif
