/***************************************************************************
 *   Copyright (C) 2004-2005 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qfile.h>
#include <qapplication.h>
#include <qregexp.h>
#include <qbuffer.h>

#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <kio/netaccess.h>
#include <kurl.h>

#include <fileimporterbibtex.h>
#include "webqueryamatex.h"

namespace KBibTeX
{
    WebQueryAmatex::WebQueryAmatex( QWidget* parent, const char* name ): WebQuery( parent, name )
    {
        m_wizard = new WebQueryWizardAmatex( title(), parent, name );
    }

    WebQueryAmatex::~WebQueryAmatex()
    {
        delete m_wizard;
    }

    BibTeX::File* WebQueryAmatex::query( )
    {
        if ( m_wizard->exec() == QDialog::Accepted )
            return m_wizard->result();
        else
            return NULL;
    }

    int WebQueryAmatex::uniqueId()
    {
        return 0x4fb803ac;
    }

    QString WebQueryAmatex::title()
    {
        return i18n( "Amatex" );
    }

    WebQueryWizardAmatex::WebQueryWizardAmatex( const QString& caption, QWidget* parent, const char* name ): WebQueryWizard( caption, i18n( "About Amatex" ), "http://www.2ndminute.org:8080/amatex/pages/about.jsp", FALSE, FALSE, parent, name )
    {
// nothing
    }

    WebQueryWizardAmatex::~WebQueryWizardAmatex()
    {
// nothing
    }

    void WebQueryWizardAmatex::startSearch()
    {
        setEnabled( FALSE );
        QApplication::setOverrideCursor( Qt::waitCursor );
        m_listViewResults->clear();

        KURL url = KURL( QString( "http://www.2ndminute.org:8080/amatex/search.do?lang=US&querry=%1&suchart=kwd" ).arg( m_lineEditQuery->text().replace( "%", "%25" ).replace( " ", "+" ).replace( "?", "%3F" ).replace( "&", "%26" ) ) );

        QString key = m_lineEditQuery->text().replace( QRegExp( "[^A-Za-z0-9]" ), "" );
        int count = 0;
        QString tmpFile;
        if ( KIO::NetAccess::download( url, tmpFile, NULL ) )
        {
            QFile inputFile( tmpFile );
            inputFile.open( IO_ReadOnly );
            QTextStream ts( &inputFile );
            QString completeText = ts.read();
            inputFile.close();
            KIO::NetAccess::removeTempFile( tmpFile );
            completeText = completeText.replace( "<br>", "\n" ).replace( QRegExp( "<[^>]+>" ), "" );
            KIO::NetAccess::removeTempFile( tmpFile );

            BibTeX::FileImporterBibTeX importer( FALSE );
            importer.setIgnoreComments( TRUE );
            QBuffer buffer( completeText.utf8() );
            buffer.open( IO_ReadOnly );
            BibTeX::File *tmpBibFile = importer.load( &buffer );
            buffer.close();

            for ( BibTeX::File::ElementList::iterator it = tmpBibFile->begin(); it != tmpBibFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                {
                    entry->setId( QString( "Amatex_%1_%2" ).arg( key ).arg( ++count ) );
                    new ResultsListViewItem( m_listViewResults, new BibTeX::Entry( entry ) );
                }
            }

            delete tmpBibFile;

        }
        else
            KMessageBox::error( this, KIO::NetAccess::lastErrorString() );

        setEnabled( TRUE );
        QApplication::restoreOverrideCursor();
    }

}
