//
// C++ Interface: searchmanager
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
// Based on tellico

#ifndef Z3950SEARCHER_H
#define Z3950SEARCHER_H


#include "searcher.h"
#include "searcherconfigwidget.h"
#include "z3950connection.h"
#include <kconfig.h>
#include <qguardedptr.h>
#include "xslthandler.h"

class KLineEdit;
class KIntSpinBox;
class KComboBox;

class Z3950ConfigWidget : public SearcherConfigWidget {
	public:
		Z3950ConfigWidget(QWidget* parent, Z3950Searcher* searcher = 0);
		~Z3950ConfigWidget() {};
//		virtual void saveConfig(KConfig* config_);
		virtual void updateSearcher();

	private:
		KLineEdit* m_hostEdit;
		KIntSpinBox* m_portSpinBox;
		KLineEdit* m_databaseEdit;
		KLineEdit* m_userEdit;
		KLineEdit* m_passwordEdit;
		KComboBox* m_charSetCombo;
		KComboBox* m_syntaxCombo;
    // have to remember syntax
		QString m_syntax;
//		Z3950Searcher* m_searcher;
};


class Z3950Searcher : public searcher {
Q_OBJECT

public:
  Z3950Searcher(QObject* parent, const char* name = 0);
  Z3950Searcher(QString source_, QString host_, uint port, QString db_, QString syntax_, QString charset_, QObject* parent, const char* name = 0);
  
  virtual ~Z3950Searcher();

  virtual QString source() const;
  virtual void setSource(const QString );
  virtual QString helpURL() {return QString::fromLatin1("http://www.loc.gov/z3950/agency/")  ; }
  virtual Type type() const { return Z3950; }
  virtual void readConfig(KConfig* config, const QString& group);
  virtual void saveConfig(KConfig* config);
  virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
  virtual void search(QString queryString);
  virtual bool isSearching() const { return m_started; }
  virtual bool isWaitingRetrieveRange() const { return m_waitingRetrieveRange; }
  virtual void stop();
  virtual void retrieveRange(unsigned int min, unsigned int max);
  virtual QStringList searchKey();
  virtual int maxSearchTerms() {return 100; }
  static QString defaultName();
  const QString& host() const { return m_host; }
  virtual SearcherConfigWidget* configWidget(QWidget* parent);

  friend class Z3950ConfigWidget;
  
protected:
	virtual void customEvent(QCustomEvent* event);

private:
		void processSearch();
		
  
	private:
		void handleResult(const QString& result);
#if HAVE_XSLT		
		XSLTHandler* m_MARC21XMLHandler;
		XSLTHandler* m_UNIMARCXMLHandler;
		bool initMARC21Handler();
		bool initUNIMARCHandler();
#endif
		void done();
		
		Z3950Connection *m_conn;
		QString m_host;
		uint m_port;
		QString m_dbname;
		QString m_user;
		QString m_password;
		QString m_sourceCharSet;
		QString m_syntax;
		QString m_esn;
		QString m_pqn;
		
		bool m_started;
		SearchKey m_key;
		QString m_value;
		
		QGuardedPtr<KConfig> m_config;
		QString m_configGroup;
		

};
#endif
