//
// C++ Interface: xslthandler
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
// 
// Copyright: See COPYING file that comes with this distribution
//
//
#include <config.h>
#if HAVE_XSLT

#ifndef XSLTHANDLER_H
#define XSLTHANDLER_H

#include <kurl.h>

#include <qmap.h>

extern "C" {
// for xmlDocPtr
#include <libxml/tree.h>
// for xsltStyleSheetPtr
#include <libxslt/xsltInternals.h>
}


/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
	Based on tellico
*/
class XSLTHandler{
public:
		class XMLOutputBuffer {
			public:
				XMLOutputBuffer();
				~XMLOutputBuffer();
				bool isValid() const { return (m_buf != 0); }
				xmlOutputBuffer* buffer() const { return m_buf; }
				QString result() const { return m_res; }
			private:
				xmlOutputBuffer* m_buf;
				QString m_res;
		};
		XSLTHandler(const KURL& xsltURL);
		~XSLTHandler();

		bool isValid() const { return (m_stylesheet != NULL); }
		QString applyStylesheet(const QString& text);
	private:
		void init();
		QString process();

		xsltStylesheetPtr m_stylesheet;
		xmlDocPtr m_docIn;
		xmlDocPtr m_docOut;

		QMap<QCString, QCString> m_params;

		static int s_initCount;


};


#endif

#endif
