//
// C++ Interface: searcherconfigdlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SEARCHERCONFIGDLG_H
#define SEARCHERCONFIGDLG_H

#include <kdialogbase.h>

#include "searcher.h"
class KLineEdit;
class QComboBox;
class QWidgetStack;

class SearcherConfigWidget;

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class SearcherConfigDlg : public KDialogBase
{
Q_OBJECT
public:
	SearcherConfigDlg( QWidget* parent);
	SearcherConfigDlg(const QString& sourceName, Type type,
						SearcherConfigWidget* configWidget, QWidget* parent);

    ~SearcherConfigDlg();
	QString sourceName();
	Type sourceType() const;
	SearcherConfigWidget* currentConfigWidget() { return m_configWidget; }
	private slots:
		void slotNewSourceSelected(const QString&);	
	private:
		void init(Type);

		bool m_newSource : 1;
		bool m_useDefaultName : 1;
		SearcherConfigWidget* m_configWidget;
		KLineEdit* m_nameEdit;
		QComboBox* m_typeCombo;
		QBoxLayout* vlay2;
		QWidget* widget;
		Type currentType;
	

};

#endif
